/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring.servlet;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SessionManager {
    public static final String SESSION_ID_PARAMETER = "sessionId";
    private static final SessionManager INSTANCE = new SessionManager();
    private final Map<String, Session> openedSessions = new HashMap<String, Session>();

    public static SessionManager getInstance() {
        return INSTANCE;
    }

    private SessionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createNewSession(String name, String password) {
        Session session = new Session(name, password);
        Map<String, Session> map = this.openedSessions;
        synchronized (map) {
            this.openedSessions.put(session.getId(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session removeSession(String token) {
        Map<String, Session> map = this.openedSessions;
        synchronized (map) {
            return this.openedSessions.remove(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTokenExists(String token) {
        if (token == null) {
            return false;
        }
        Map<String, Session> map = this.openedSessions;
        synchronized (map) {
            return this.openedSessions.containsKey(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        Map<String, Session> map = this.openedSessions;
        synchronized (map) {
            return this.openedSessions.get(sessionId);
        }
    }

    public class Session {
        private final String name;
        private final String password;
        private final String id;

        public Session(String pName, String pPassword) {
            this.name = pName;
            this.id = UUID.randomUUID().toString();
            this.password = pPassword;
        }

        public String getName() {
            return this.name;
        }

        public String getPassword() {
            return this.password;
        }

        public String getId() {
            return this.id;
        }
    }
}

