/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.sdt.home.monitoring.servlet.CredentialsServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.HomeServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.InCseContextServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.LoginServlet;
import org.eclipse.om2m.sdt.home.monitoring.servlet.LogoutServlet;
import org.eclipse.om2m.sdt.home.monitoring.util.AeRegistration;
import org.eclipse.om2m.sdt.home.monitoring.util.ResourceDiscovery;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
ManagedService {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    public String globalContext = System.getProperty("org.eclipse.om2m.globalContext", "");
    public static String uiContext = "";
    public static String sep = "/";
    public static String CAMERAURL = "";
    private ServiceTracker httpServiceTracker;
    private ServiceTracker sclServiceTracker;

    public void start(BundleContext context) throws Exception {
        this.initCseServiceTracker(context);
        if (uiContext.equals("/")) {
            sep = "";
        }
        this.httpServiceTracker = new ServiceTracker(context, HttpService.class.getName(), null){

            public void removedService(ServiceReference reference, Object service) {
                LOGGER.info((Object)"HttpService removed");
                try {
                    LOGGER.info((Object)("Unregister " + uiContext + sep + " http context"));
                    ((HttpService)service).unregister(String.valueOf(uiContext) + sep + "Home_Monitoring_Application");
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error unregistring webapp servlet", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference reference) {
                LOGGER.info((Object)"HttpService discovered");
                HttpService httpService = (HttpService)this.context.getService(reference);
                try {
                    LOGGER.info((Object)("Register test " + uiContext + sep + "Home_Monitoring_Application http context"));
                    httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application", (Servlet)new HomeServlet(this.context), null, null);
                    httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/in-cse/context", (Servlet)new InCseContextServlet(), null, null);
                    httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/security/login", (Servlet)new LoginServlet(this.context), null, null);
                    httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/security/cred", (Servlet)new CredentialsServlet(this.context), null, null);
                    httpService.registerServlet(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/security/logout", (Servlet)new LogoutServlet(this.context), null, null);
                    httpService.registerResources(String.valueOf(uiContext) + sep + "Home_Monitoring_Application" + "/webapps", String.valueOf(uiContext) + sep + "webapps", null);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error registring webapp servlet", (Throwable)e);
                }
                return httpService;
            }
        };
        this.httpServiceTracker.open();
        Hashtable<String, String> dic = new Hashtable<String, String>();
        ((Dictionary)dic).put("service.pid", "home.monitoring.application");
        context.registerService(ManagedService.class.getName(), (Object)new Activator(), dic);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.sclServiceTracker.close();
            this.httpServiceTracker.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCseServiceTracker(final BundleContext bundleContext) {
        this.sclServiceTracker = new ServiceTracker(bundleContext, CseService.class.getName(), null){
            private ServiceRegistration sr;

            public void removedService(ServiceReference reference, Object service) {
                this.sr.unregister();
                AeRegistration.getInstance().deleteAe();
                AeRegistration.getInstance().setCseService(null);
                LOGGER.info((Object)"CSEService removed");
            }

            public Object addingService(ServiceReference reference) {
                LOGGER.info((Object)"CSEService Tracker found");
                CseService cseService = (CseService)this.context.getService(reference);
                AeRegistration.getInstance().setCseService(cseService);
                AeRegistration.getInstance().createAe();
                this.sr = bundleContext.registerService(InterworkingService.class, (Object)AeRegistration.getInstance(), null);
                ResourceDiscovery.initCseService(cseService);
                return cseService;
            }
        };
        this.sclServiceTracker.open();
    }

    public void updated(Dictionary dictionary) throws ConfigurationException {
        if (dictionary != null) {
            CAMERAURL = dictionary.get("ip.camera.url").toString();
        }
    }
}

