/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.CseUtil;
import org.eclipse.om2m.ipe.sdt.ModuleSDTListener;
import org.eclipse.om2m.ipe.sdt.SDTActionAdaptor;
import org.eclipse.om2m.ipe.sdt.flexcontainerservice.ModuleFlexContainerService;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.datapoints.AbstractDateDataPoint;
import org.eclipse.om2m.sdt.datapoints.ArrayDataPoint;
import org.eclipse.om2m.sdt.datapoints.ValuedDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;

public class SDTModuleAdaptor {
    private static Log logger = LogFactory.getLog(SDTModuleAdaptor.class);
    private static final String SEP = "/";
    private static final String SDT_IPE_SUBSCRIPTION_NAME = "SDT_IPE_SUBSCRIPTION";
    private final boolean hasToBeAnnounced;
    private final Module module;
    private final CseService cseService;
    private final String parentLocation;
    private final String resourceLocation;
    private final String announceCseId;
    private final Map<String, SDTActionAdaptor> actions;
    private ModuleFlexContainerService moduleFlexContainerService;
    private ModuleSDTListener moduleSDTListener;

    public SDTModuleAdaptor(Module pModule, CseService pCseService, String pParentLocation, String pAnnounceCseId, boolean hasToBeAnnounced) {
        this.module = pModule;
        this.hasToBeAnnounced = hasToBeAnnounced;
        this.cseService = pCseService;
        this.parentLocation = pParentLocation;
        this.resourceLocation = String.valueOf(this.parentLocation) + SEP + this.module.getName();
        this.announceCseId = pAnnounceCseId;
        this.actions = new HashMap<String, SDTActionAdaptor>();
    }

    public boolean publishModuleIntoOM2MTree() {
        logger.info((Object)("publishModuleFromOM2MTree(name=" + this.module.getName() + ", parentLocation=" + this.parentLocation + ")"));
        AbstractFlexContainer flexContainer = FlexContainerFactory.getSpecializationFlexContainer((String)this.module.getShortDefinitionName());
        flexContainer.setName(this.module.getName());
        flexContainer.setContainerDefinition(this.module.getDefinition());
        flexContainer.setLongName(this.module.getLongDefinitionName());
        flexContainer.setShortName(this.module.getShortDefinitionName());
        if (this.hasToBeAnnounced) {
            flexContainer.getAnnounceTo().add(SEP + this.announceCseId);
        }
        flexContainer.getLabels().add("name/" + this.module.getName());
        flexContainer.getLabels().add("pid/" + this.module.getPid());
        flexContainer.getLabels().add("device.id/" + this.module.getOwner().getId());
        flexContainer.getLabels().add("device.name/" + this.module.getOwner().getName());
        flexContainer.getLabels().add("object.type/module");
        flexContainer.getLabels().add("cntDef/" + this.module.getDefinition());
        flexContainer.getLabels().add("OTB.CATEGORY/Read");
        flexContainer.getLabels().add("OTB.CATEGORY/Write");
        flexContainer.getLabels().add("OTB.CATEGORY/Notify");
        for (DataPoint dp : this.module.getDataPoints()) {
            CustomAttribute customAttribute = new CustomAttribute();
            String customAttributeName = dp.getShortDefinitionType();
            if (customAttributeName == null) {
                customAttributeName = dp.getName();
            }
            customAttribute.setCustomAttributeName(customAttributeName);
            String value = null;
            try {
                if (dp instanceof AbstractDateDataPoint) {
                    value = ((AbstractDateDataPoint)dp).getStringValue();
                } else if (dp instanceof ArrayDataPoint) {
                    List values = (List)((ArrayDataPoint)dp).getValue();
                    if (values != null) {
                        StringBuffer sb = new StringBuffer();
                        boolean first = true;
                        for (Object i : values) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(",");
                            }
                            sb.append(i.toString());
                        }
                        value = sb.toString();
                    }
                } else {
                    Object val = ((ValuedDataPoint)dp).getValue();
                    if (val != null) {
                        value = val.toString();
                    }
                }
            }
            catch (DataPointException e) {
                logger.info((Object)("Error reading datapoint " + dp + ": " + e.getMessage()));
            }
            catch (AccessException e) {
                logger.info((Object)("Error accessing datapoint " + dp + ": " + e.getMessage()));
            }
            catch (Exception e) {
                logger.error((Object)("Error in datapoint " + dp), (Throwable)e);
            }
            customAttribute.setCustomAttributeValue(value);
            logger.info((Object)("add DataPoint customAttribute(" + customAttribute + ")"));
            flexContainer.getCustomAttributes().add(customAttribute);
        }
        for (Property sdtProperty : this.module.getProperties()) {
            if (sdtProperty.getType() == null || sdtProperty.getValue() == null && sdtProperty.isOptional()) continue;
            CustomAttribute caForSdtProperty = new CustomAttribute();
            caForSdtProperty.setCustomAttributeName(sdtProperty.getShortName());
            caForSdtProperty.setCustomAttributeValue(sdtProperty.getValue());
            logger.info((Object)("add Property customAttribute(" + caForSdtProperty + ")"));
            flexContainer.getCustomAttributes().add(caForSdtProperty);
        }
        logger.info((Object)("customAttributes: " + flexContainer.getCustomAttributes()));
        ResponsePrimitive resp = CseUtil.sendCreateFlexContainerRequest(this.cseService, flexContainer, this.parentLocation);
        if (!resp.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            logger.error((Object)("publishModuleFromOM2MTree(name=" + this.module.getName() + ", parentLocation=" + this.parentLocation + ") : failed to publish:" + resp.getContent()), null);
            return false;
        }
        AbstractFlexContainer createdFlexContainer = (AbstractFlexContainer)resp.getContent();
        this.moduleFlexContainerService = new ModuleFlexContainerService(this.module, createdFlexContainer.getResourceID());
        this.moduleFlexContainerService.register();
        for (Action action : this.module.getActions()) {
            SDTActionAdaptor actionAdaptor = new SDTActionAdaptor(this.cseService, action, this.resourceLocation, this.module, this.announceCseId, this.hasToBeAnnounced);
            if (actionAdaptor.publishActionIntoOM2MTree()) {
                this.actions.put(action.getName(), actionAdaptor);
                continue;
            }
            this.unpublishModuleFromOM2MTree();
            return false;
        }
        this.moduleSDTListener = new ModuleSDTListener(this.module, this.cseService, this.resourceLocation);
        this.moduleSDTListener.register();
        return true;
    }

    public void unpublishModuleFromOM2MTree() {
        logger.info((Object)("unpublishModuleFromOM2MTree(name=" + this.module.getName() + ", location=" + this.resourceLocation + ")"));
        this.moduleSDTListener.unregister();
        this.moduleSDTListener = null;
        for (SDTActionAdaptor sdtActionAdaptor : this.actions.values()) {
            sdtActionAdaptor.unpublishActionFromOM2MTree();
        }
        this.actions.clear();
        if (this.moduleFlexContainerService != null) {
            this.moduleFlexContainerService.unregister();
        }
        CseUtil.sendDeleteRequest(this.cseService, this.resourceLocation);
    }
}

