/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.sdt.model;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.actions.Toggle;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class SampleBinarySwitch
extends BinarySwitch {
    public SampleBinarySwitch(String name, Domain domain) {
        super(name, domain, new BooleanDataPoint((Identifiers)DatapointType.powerState){
            private Boolean powerState = Boolean.FALSE;

            public void doSetValue(Boolean value) throws DataPointException {
                this.powerState = value;
            }

            public Boolean doGetValue() throws DataPointException {
                return this.powerState;
            }
        });
        this.setToggle(new Toggle("toggle"){

            protected void doToggle() throws ActionException {
                try {
                    SampleBinarySwitch.this.setPowerState(!SampleBinarySwitch.this.getPowerState());
                }
                catch (DataPointException e) {
                    throw new ActionException((Throwable)e);
                }
                catch (AccessException e) {
                    throw new ActionException((Throwable)e);
                }
            }
        });
    }

    public void setPowerState(boolean v) throws DataPointException, AccessException {
        super.setPowerState(v);
        Event evt = new Event("SWITCH " + this.getOwner().getId());
        evt.addDataPoint(this.getDataPointByShortName(DatapointType.powerState.getShortName()));
        evt.setValue((Object)v);
        this.addEvent(evt);
    }
}

