/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.FloodDetector;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedFaultDetection;
import org.eclipse.om2m.sdt.home.modules.AbstractAlarmSensor;
import org.eclipse.om2m.sdt.home.modules.WaterSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedFloodDetector
extends FloodDetector
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;
    private boolean waterAlarm = false;
    private boolean running = false;
    private WaterSensor waterSensor;

    public MockedFloodDetector(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.waterSensor = new WaterSensor("waterSensor_" + id, domain, new BooleanDataPoint((Identifiers)DatapointType.alarm){

            public Boolean doGetValue() throws DataPointException {
                return MockedFloodDetector.this.waterAlarm;
            }
        });
        this.addModule((AbstractAlarmSensor)this.waterSensor);
        this.addModule(new MockedFaultDetection("faultDetection_" + id, domain));
    }

    @Override
    public void registerDevice() {
        this.running = true;
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (MockedFloodDetector.this.running) {
                    try {
                        Thread.sleep((int)(30000.0 + 10000.0 * Math.random()));
                        Activator.logger.info("Generating Flood Alarm event");
                        Event evt = new Event("ALARM");
                        MockedFloodDetector.this.waterAlarm = !MockedFloodDetector.this.waterAlarm;
                        evt.addDataPoint(MockedFloodDetector.this.waterSensor.getDataPoint("alarm"));
                        evt.setValue((Object)MockedFloodDetector.this.waterAlarm);
                        MockedFloodDetector.this.waterSensor.addEvent(evt);
                    }
                    catch (Throwable e) {
                        Activator.logger.warning("Error generating event", e);
                    }
                }
            }
        }).start();
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

