/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;

public class ASMByteCodeAnalyzer {
    private static final int ACC_TEAM = 32768;
    private Map<String, ClassInformation> classInformationMap = new ConcurrentHashMap<String, ClassInformation>(512, 0.75f, 4);

    public ClassInformation getClassInformation(InputStream classStream, String className) {
        try {
            return this.getClassInformation(null, classStream, className);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ClassInformation getClassInformation(byte[] classBytes, String className) {
        try {
            return this.getClassInformation(classBytes, null, className);
        }
        catch (IOException e) {
            return null;
        }
    }

    private ClassInformation getClassInformation(byte[] classBytes, InputStream classStream, String className) throws IOException {
        ClassInformation classInformation = this.classInformationMap.get(className);
        if (classInformation != null) {
            return classInformation;
        }
        ClassReader classReader = classBytes != null ? new ClassReader(classBytes) : new ClassReader(classStream);
        classInformation = new ClassInformation(classReader);
        this.classInformationMap.put(className, classInformation);
        return classInformation;
    }

    public static class ClassInformation {
        private int modifiers;
        private String superClassName;
        private String[] superInterfaceNames;

        ClassInformation(ClassReader classReader) {
            this.modifiers = classReader.getAccess();
            this.superClassName = classReader.getSuperName();
            this.superInterfaceNames = classReader.getInterfaces();
        }

        public boolean isTeam() {
            return (this.modifiers & 0x8000) != 0;
        }

        public boolean isInterface() {
            return (this.modifiers & 0x200) != 0;
        }

        public String getSuperClassName() {
            if (this.superClassName != null) {
                return this.superClassName.replace('/', '.');
            }
            return null;
        }

        public String[] getSuperInterfaceNames() {
            if (this.superInterfaceNames != null) {
                int i = 0;
                while (i < this.superInterfaceNames.length) {
                    this.superInterfaceNames[i] = this.superInterfaceNames[i].replace('/', '.');
                    ++i;
                }
            }
            return this.superInterfaceNames;
        }
    }
}

