/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableDoubleStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.DoubleArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

@ServiceProvider(value=MutableDoubleStackFactory.class)
public class MutableDoubleStackFactoryImpl
implements MutableDoubleStackFactory {
    public static final MutableDoubleStackFactory INSTANCE = new MutableDoubleStackFactoryImpl();

    public MutableDoubleStack empty() {
        return new DoubleArrayStack();
    }

    public MutableDoubleStack of() {
        return this.empty();
    }

    public MutableDoubleStack with() {
        return this.empty();
    }

    public MutableDoubleStack of(double ... items) {
        return this.with(items);
    }

    public MutableDoubleStack with(double ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return DoubleArrayStack.newStackWith(items);
    }

    public MutableDoubleStack ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public MutableDoubleStack withAll(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStack(items);
    }

    public MutableDoubleStack ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    public MutableDoubleStack withAll(Iterable<Double> iterable) {
        MutableDoubleStack stack = DoubleStacks.mutable.empty();
        Iterate.forEach(iterable, arg_0 -> ((MutableDoubleStack)stack).push(arg_0));
        return stack;
    }

    public MutableDoubleStack ofAllReversed(DoubleIterable items) {
        return this.withAllReversed(items);
    }

    public MutableDoubleStack withAllReversed(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStackFromTopToBottom(items);
    }

    public MutableDoubleStack ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    public MutableDoubleStack withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

