/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.indicator;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.hideshow.indicator.ColumnHideIndicatorEventMatcher;
import org.eclipse.nebula.widgets.nattable.hideshow.indicator.RowHideIndicatorEventMatcher;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.action.RowResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.widgets.Menu;

public class HideIndicatorMenuConfiguration
extends AbstractUiBindingConfiguration {
    protected ILayer columnHeaderLayer;
    protected ILayer rowHeaderLayer;
    protected Menu columnHideIndicatorMenu;
    protected Menu rowHideIndicatorMenu;

    public HideIndicatorMenuConfiguration(NatTable natTable, ILayer columnHeaderLayer, ILayer rowHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
        this.rowHeaderLayer = rowHeaderLayer;
        this.columnHideIndicatorMenu = this.createColumnHeaderMenu(natTable).build();
        this.rowHideIndicatorMenu = this.createRowHeaderMenu(natTable).build();
    }

    protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable).withMenuItemProvider(MenuItemProviders.showColumnMenuItemProvider(true, "%MenuItemProviders.showColumn", null)).withMenuItemProvider(MenuItemProviders.showAllColumnsMenuItemProvider("%MenuItemProviders.showAllColumns", null));
    }

    protected PopupMenuBuilder createRowHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable).withMenuItemProvider(MenuItemProviders.showRowMenuItemProvider(true, "%MenuItemProviders.showRow", null)).withMenuItemProvider(MenuItemProviders.showAllRowsMenuItemProvider("%MenuItemProviders.showAllRows", null));
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        if (this.columnHideIndicatorMenu != null) {
            uiBindingRegistry.registerFirstMouseMoveBinding(new ColumnHideIndicatorEventMatcher(0, "COLUMN_HEADER", 0, this.columnHeaderLayer), new ColumnResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDownBinding(new ColumnHideIndicatorEventMatcher(0, "COLUMN_HEADER", 3, this.columnHeaderLayer), new PopupMenuAction(this.columnHideIndicatorMenu));
        }
        if (this.rowHideIndicatorMenu != null) {
            uiBindingRegistry.registerFirstMouseMoveBinding(new RowHideIndicatorEventMatcher(0, "ROW_HEADER", 0, this.rowHeaderLayer), new RowResizeCursorAction());
            uiBindingRegistry.registerFirstMouseDownBinding(new RowHideIndicatorEventMatcher(0, "ROW_HEADER", 3, this.rowHeaderLayer), new PopupMenuAction(this.rowHideIndicatorMenu));
        }
        if (this.columnHideIndicatorMenu != null || this.rowHideIndicatorMenu != null) {
            uiBindingRegistry.registerMouseMoveBinding(new MouseEventMatcher(), new ClearCursorAction());
        }
    }
}

