/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.data.command;

import ca.odell.glazedlists.EventList;
import java.util.HashMap;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.command.RowDeleteCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowObjectDeleteEvent;

public class GlazedListsRowDeleteCommandHandler<T>
implements ILayerCommandHandler<RowDeleteCommand> {
    protected EventList<T> bodyData;

    public GlazedListsRowDeleteCommandHandler(EventList<T> bodyData) {
        this.bodyData = bodyData;
    }

    public boolean doCommand(ILayer targetLayer, RowDeleteCommand command) {
        if (command.convertToTargetLayer(targetLayer)) {
            int[] positions = command.getRowPositionsArray();
            HashMap<Integer, Object> deleted = new HashMap<Integer, Object>();
            this.bodyData.getReadWriteLock().writeLock().lock();
            try {
                int i = positions.length - 1;
                while (i >= 0) {
                    int pos = positions[i];
                    deleted.put(pos, this.bodyData.remove(pos));
                    --i;
                }
            }
            finally {
                this.bodyData.getReadWriteLock().writeLock().unlock();
            }
            targetLayer.fireLayerEvent((ILayerEvent)new RowObjectDeleteEvent(targetLayer, deleted));
            return true;
        }
        return false;
    }

    public Class<RowDeleteCommand> getCommandClass() {
        return RowDeleteCommand.class;
    }
}

