/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.ContextualDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;

public class GroupByDisplayConverter<T>
extends ContextualDisplayConverter {
    private Object defaultSummaryValue = ISummaryProvider.DEFAULT_SUMMARY_VALUE;
    protected final Map<Integer, IDisplayConverter> wrappedConverters = new HashMap<Integer, IDisplayConverter>();
    protected final Map<Integer, IDisplayConverter> converterCache = new HashMap<Integer, IDisplayConverter>();
    protected final GroupByDataLayer<T> groupByDataLayer;

    public GroupByDisplayConverter(GroupByDataLayer<T> groupByDataLayer) {
        this.groupByDataLayer = groupByDataLayer;
    }

    public GroupByDisplayConverter(GroupByDataLayer<T> groupByDataLayer, Object defaultSummaryValue) {
        this.groupByDataLayer = groupByDataLayer;
        this.defaultSummaryValue = defaultSummaryValue;
    }

    public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
        if (cell.getConfigLabels().hasLabel("TREE_COLUMN_CELL")) {
            Object displayValue = this.getDisplayValue(cell, configRegistry, canonicalValue);
            if (canonicalValue instanceof GroupByObject) {
                GroupByObject groupByObject = (GroupByObject)canonicalValue;
                String childCountPattern = (String)configRegistry.getConfigAttribute(GroupByConfigAttributes.GROUP_BY_CHILD_COUNT_PATTERN, DisplayMode.NORMAL, (List)cell.getConfigLabels());
                if (childCountPattern != null && childCountPattern.length() > 0) {
                    List<T> children = this.groupByDataLayer.getItemsInGroup(groupByObject);
                    int directChildCount = this.groupByDataLayer.getTreeRowModel().getDirectChildren(cell.getRowIndex()).size();
                    displayValue = String.valueOf(String.valueOf(displayValue)) + " " + MessageFormat.format(childCountPattern, children.size(), directChildCount);
                }
            }
            return displayValue;
        }
        if (cell.getConfigLabels().hasLabel("GROUP_BY_SUMMARY")) {
            if (canonicalValue == null) {
                return this.defaultSummaryValue;
            }
            return this.getDisplayValue(cell, configRegistry, canonicalValue);
        }
        return "";
    }

    public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
        return displayValue;
    }

    protected Object getDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
        IDisplayConverter converter = null;
        Object canonical = canonicalValue;
        if (this.wrappedConverters.containsKey(cell.getColumnIndex())) {
            converter = this.wrappedConverters.get(cell.getColumnIndex());
        } else if (canonicalValue instanceof GroupByObject) {
            GroupByObject groupByObject = (GroupByObject)canonicalValue;
            int lastGroupingIndex = -1;
            for (Map.Entry<Integer, Object> groupEntry : groupByObject.getDescriptor().entrySet()) {
                lastGroupingIndex = groupEntry.getKey();
            }
            if (lastGroupingIndex >= 0) {
                canonical = ((GroupByObject)canonicalValue).getValue();
                if (this.converterCache.containsKey(lastGroupingIndex)) {
                    converter = this.converterCache.get(lastGroupingIndex);
                } else {
                    int rowPosition = cell.getRowPosition() + 1;
                    LabelStack stackBelow = this.groupByDataLayer.getConfigLabelsByPosition(lastGroupingIndex, rowPosition);
                    while (stackBelow.hasLabel("GROUP_BY_OBJECT")) {
                        stackBelow = this.groupByDataLayer.getConfigLabelsByPosition(lastGroupingIndex, ++rowPosition);
                    }
                    converter = (IDisplayConverter)configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.NORMAL, (List)stackBelow);
                    if (!this.converterCache.containsKey(lastGroupingIndex)) {
                        this.converterCache.put(lastGroupingIndex, converter);
                    }
                }
            }
        } else {
            ArrayList labels = new ArrayList(cell.getConfigLabels());
            labels.remove("GROUP_BY_OBJECT");
            converter = (IDisplayConverter)configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.NORMAL, labels);
            if (converter == this) {
                converter = null;
            }
        }
        if (converter == null) {
            converter = new DefaultDisplayConverter();
        }
        return converter.canonicalToDisplayValue(cell, configRegistry, canonical);
    }

    public void registerUnderlyingDisplayConverter(int columnIndex, IDisplayConverter converter) {
        this.wrappedConverters.put(columnIndex, converter);
    }

    public void unregisterUnderlyingDisplayConverter(int columnIndex) {
        this.wrappedConverters.remove(columnIndex);
    }

    public void clearConverterCache() {
        this.converterCache.clear();
    }
}

