/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.action.ColumnGroupExpandCollapseAction;
import org.eclipse.nebula.widgets.nattable.group.action.ColumnGroupHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.group.action.ColumnHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.group.action.CreateColumnGroupAction;
import org.eclipse.nebula.widgets.nattable.group.action.UngroupColumnsAction;
import org.eclipse.nebula.widgets.nattable.group.action.ViewportSelectColumnGroupAction;
import org.eclipse.nebula.widgets.nattable.group.painter.ColumnGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.SWT;

public class DefaultColumnGroupHeaderLayerConfiguration
implements IConfiguration {
    public static final String GROUP_COLLAPSED_CONFIG_TYPE = "GROUP_COLLAPSED";
    public static final String GROUP_EXPANDED_CONFIG_TYPE = "GROUP_EXPANDED";
    private final ColumnGroupModel columnGroupModel;
    private final boolean enableColumnGroupSelectionHandling;

    public DefaultColumnGroupHeaderLayerConfiguration(ColumnGroupModel columnGroupModel) {
        this(columnGroupModel, false);
    }

    public DefaultColumnGroupHeaderLayerConfiguration(ColumnGroupModel columnGroupModel, boolean enableGroupSelection) {
        this.columnGroupModel = columnGroupModel;
        this.enableColumnGroupSelectionHandling = enableGroupSelection;
    }

    @Override
    public void configureLayer(ILayer layer) {
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new BeveledBorderDecorator(new ColumnGroupHeaderTextPainter()), "NORMAL", "COLUMN_GROUP_HEADER");
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnGroupHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new ColumnGroupHeaderReorderDragMode(this.columnGroupModel)));
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new ColumnHeaderReorderDragMode(this.columnGroupModel)));
        if (!this.enableColumnGroupSelectionHandling) {
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new NoOpMouseAction());
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1), new NoOpMouseAction());
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD2), new NoOpMouseAction());
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1 | SWT.MOD2), new NoOpMouseAction());
        } else {
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new ViewportSelectColumnGroupAction(false, false));
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1), new ViewportSelectColumnGroupAction(false, true));
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD2), new ViewportSelectColumnGroupAction(true, false));
            uiBindingRegistry.registerFirstSingleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(SWT.MOD1 | SWT.MOD2), new ViewportSelectColumnGroupAction(true, true));
        }
        uiBindingRegistry.registerDoubleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new ColumnGroupExpandCollapseAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 103), new CreateColumnGroupAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(SWT.MOD1, 117), new UngroupColumnsAction());
    }
}

