/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.CreateRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.DisplayRowGroupRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.group.command.IRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.RemoveRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupRowCommand;
import org.eclipse.nebula.widgets.nattable.group.event.GroupRowsEvent;
import org.eclipse.nebula.widgets.nattable.group.event.UngroupRowsEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.rename.HeaderRenameDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class RowGroupsCommandHandler
extends AbstractLayerCommandHandler<IRowGroupCommand> {
    private final RowGroupHeaderLayer contextLayer;
    private final SelectionLayer selectionLayer;

    public RowGroupsCommandHandler(RowGroupHeaderLayer contextLayer, SelectionLayer selectionLayer) {
        this.contextLayer = contextLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(IRowGroupCommand command) {
        if (command instanceof CreateRowGroupCommand) {
            CreateRowGroupCommand createCommand = (CreateRowGroupCommand)command;
            if (!this.handleCreateRowGroupCommand(createCommand.getRowGroupName())) {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 33);
                messageBox.setText(Messages.getString("ErrorDialog.title"));
                messageBox.setMessage(Messages.getString("RowGroups.selectNonGroupedRows"));
                messageBox.open();
            }
            return true;
        }
        if (command instanceof RemoveRowGroupCommand) {
            RemoveRowGroupCommand removeRowGroupCommand = (RemoveRowGroupCommand)command;
            int rowIndex = removeRowGroupCommand.getRowIndex();
            this.handleRemoveRowGroupCommand(rowIndex);
            return true;
        }
        if (command instanceof UngroupRowCommand) {
            this.handleUngroupCommand();
            return true;
        }
        if (command instanceof DisplayRowGroupRenameDialogCommand) {
            return this.displayRowGroupRenameDialog((DisplayRowGroupRenameDialogCommand)command);
        }
        return false;
    }

    protected boolean handleCreateRowGroupCommand(String rowGroupName) {
        int[] fullySelectedRows = this.selectionLayer.getFullySelectedRowPositions();
        GroupModel model = this.contextLayer.getGroupModel();
        TreeSet<Integer> positionsToGroup = new TreeSet<Integer>();
        if (fullySelectedRows != null && fullySelectedRows.length > 0) {
            int[] nArray = fullySelectedRows;
            int n = fullySelectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                int converted = LayerUtil.convertRowPosition(this.selectionLayer, row, this.contextLayer.getPositionLayer());
                if (converted > -1) {
                    positionsToGroup.add(converted);
                }
                ++n2;
            }
            HashSet<GroupModel.Group> existingGroups = new HashSet<GroupModel.Group>();
            Iterator it = positionsToGroup.iterator();
            while (it.hasNext()) {
                int row = (Integer)it.next();
                GroupModel.Group group = model.getGroupByPosition(row);
                if (group == null) continue;
                if (!group.isUnbreakable()) {
                    existingGroups.add(group);
                    continue;
                }
                it.remove();
            }
            if (!existingGroups.isEmpty()) {
                this.contextLayer.doCommand(new RowGroupExpandCommand(model, existingGroups));
                for (GroupModel.Group group : existingGroups) {
                    positionsToGroup.addAll(group.getVisiblePositions());
                    this.contextLayer.removeGroup(group);
                }
            }
            ArrayList<Integer> selectedPositions = new ArrayList<Integer>(positionsToGroup);
            this.selectionLayer.doCommand(new MultiRowReorderCommand(this.selectionLayer, selectedPositions, (Integer)selectedPositions.get(0)));
            this.contextLayer.addGroup(rowGroupName, this.selectionLayer.getRowIndexByPosition((Integer)selectedPositions.get(0)), positionsToGroup.size());
            this.selectionLayer.clear();
            this.contextLayer.fireLayerEvent(new GroupRowsEvent(this.contextLayer));
            return true;
        }
        return false;
    }

    protected void handleRemoveRowGroupCommand(int rowIndex) {
        int selectedPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
        int converted = LayerUtil.convertRowPosition(this.selectionLayer, selectedPosition, this.contextLayer.getPositionLayer());
        GroupModel model = this.contextLayer.getGroupModel();
        GroupModel.Group group = model.getGroupByPosition(converted);
        if (group != null && !group.isUnbreakable()) {
            if (group.isCollapsed()) {
                this.contextLayer.doCommand(new RowGroupExpandCommand(model, group));
            }
            model.removeGroup(group);
            this.contextLayer.fireLayerEvent(new GroupRowsEvent(this.contextLayer));
        }
    }

    protected void handleUngroupCommand() {
        int[] fullySelectedRows = this.selectionLayer.getFullySelectedRowPositions();
        if (fullySelectedRows != null && fullySelectedRows.length > 0) {
            int endPos;
            TreeSet<Integer> positionsToUngroup = new TreeSet<Integer>();
            Object object = fullySelectedRows;
            int n = fullySelectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = object[n2];
                int converted = LayerUtil.convertRowPosition(this.selectionLayer, row, this.contextLayer.getPositionLayer());
                if (converted > -1) {
                    positionsToUngroup.add(converted);
                }
                ++n2;
            }
            GroupModel model = this.contextLayer.getGroupModel();
            HashMap<GroupModel.Group, ArrayList<Integer>> toRemove = new HashMap<GroupModel.Group, ArrayList<Integer>>();
            object = positionsToUngroup.iterator();
            while (object.hasNext()) {
                int n3 = (Integer)object.next();
                GroupModel.Group group = model.getGroupByPosition(n3);
                if (group == null) continue;
                endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                if (n3 < endPos && !group.isGroupStart(n3)) {
                    ArrayList<Integer> remove = (ArrayList<Integer>)toRemove.get(group);
                    if (remove == null) {
                        remove = new ArrayList<Integer>();
                        toRemove.put(group, remove);
                    }
                    remove.add(n3);
                    continue;
                }
                model.removePositionsFromGroup(group, n3);
            }
            if (!toRemove.isEmpty()) {
                for (Map.Entry entry : toRemove.entrySet()) {
                    GroupModel.Group group = (GroupModel.Group)entry.getKey();
                    endPos = group.getVisibleStartPosition() + group.getVisibleSpan();
                    this.selectionLayer.doCommand(new MultiRowReorderCommand(this.selectionLayer, (List)entry.getValue(), endPos));
                    List value = (List)entry.getValue();
                    int start = endPos - value.size();
                    int[] positionsToRemove = new int[value.size()];
                    int i = 0;
                    while (i < ((List)entry.getValue()).size()) {
                        positionsToRemove[i] = start + i;
                        ++i;
                    }
                    model.removePositionsFromGroup(group, positionsToRemove);
                }
            }
            this.selectionLayer.clear();
            this.contextLayer.fireLayerEvent(new UngroupRowsEvent(this.contextLayer));
        }
    }

    protected boolean displayRowGroupRenameDialog(DisplayRowGroupRenameDialogCommand command) {
        int rowPosition = command.getRowPosition();
        HeaderRenameDialog dialog = new HeaderRenameDialog(Display.getDefault().getActiveShell(), null, null, HeaderRenameDialog.RenameDialogLabels.ROW_RENAME);
        Rectangle rowHeaderBounds = this.contextLayer.getBoundsByPosition(rowPosition, 0);
        Point point = new Point(rowHeaderBounds.x, rowHeaderBounds.y + rowHeaderBounds.height);
        dialog.setLocation(command.toDisplayCoordinates(point));
        dialog.open();
        if (!dialog.isCancelPressed()) {
            GroupModel.Group rowGroup = this.contextLayer.getGroupByPosition(rowPosition);
            rowGroup.setName(dialog.getNewLabel());
        }
        return true;
    }

    @Override
    public Class<IRowGroupCommand> getCommandClass() {
        return IRowGroupCommand.class;
    }
}

