/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._104_Styling;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.PersistentNatExampleWrapper;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.StyledColumnHeaderConfiguration;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.StyledRowHeaderConfiguration;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultRowStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.AggregateConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.layer.stack.DummyGridLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.editor.command.DisplayColumnStyleEditorCommandHandler;
import org.eclipse.nebula.widgets.nattable.ui.menu.DebugMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _000_Styled_grid
extends AbstractNatExample {
    private static final String COLUMN_LABEL_1 = "ColumnLabel_1";
    private static final String BODY_LABEL_1 = "BodyLabel_1";

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(700, 400, new PersistentNatExampleWrapper(new _000_Styled_grid()));
    }

    @Override
    public String getDescription() {
        return "Grid demonstrates how to setup basic colors/font/border for the various regions in NatTable.\n\nFeatures:\nDifferent styles can be specified for:\n\tBody\n\tColumn header\n\tRow header\n\tDifferent states of the cell normal/selection/edit\n \tSpecific styles can be applied to arbitrary selection of cells (applied to 'Column 2' in example)\n\nKey Bindings:\n\tSelection styles can be seen by selecting a region on the table\n\tStyles can be edited by choosing the 'Column style editor' from the right click menu\n\nTechnical information:\n\tSupport is provided for automatic creation and disposal for SWT colors/fonts (see GUIHelper)";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        NatTable natTable = this.setup(parent);
        this.addCustomStyling(natTable);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.addColumnHighlight(natTable.getConfigRegistry());
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new DebugMenuConfiguration(natTable));
        natTable.configure();
        return natTable;
    }

    private NatTable setup(Composite parent) {
        DummyGridLayerStack gridLayer = new DummyGridLayerStack();
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        DataLayer bodyDataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        AggregateConfigLabelAccumulator aggregrateConfigLabelAccumulator = new AggregateConfigLabelAccumulator();
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)aggregrateConfigLabelAccumulator);
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        ColumnOverrideLabelAccumulator bodyLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        aggregrateConfigLabelAccumulator.add((IConfigLabelAccumulator)columnLabelAccumulator);
        aggregrateConfigLabelAccumulator.add((IConfigLabelAccumulator)bodyLabelAccumulator);
        bodyLabelAccumulator.registerColumnOverrides(2, new String[]{BODY_LABEL_1});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_LABEL_1});
        DisplayColumnStyleEditorCommandHandler styleChooserCommandHandler = new DisplayColumnStyleEditorCommandHandler(gridLayer.getBodyLayer().getSelectionLayer(), columnLabelAccumulator, natTable.getConfigRegistry());
        DefaultBodyLayerStack bodyLayer = gridLayer.getBodyLayer();
        bodyLayer.registerCommandHandler((ILayerCommandHandler)styleChooserCommandHandler);
        bodyLayer.registerPersistable((IPersistable)styleChooserCommandHandler);
        bodyLayer.registerPersistable((IPersistable)columnLabelAccumulator);
        return natTable;
    }

    private void addColumnHighlight(IConfigRegistry configRegistry) {
        Style style = new Style();
        style.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_BLUE);
        style.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.RIGHT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", BODY_LABEL_1);
    }

    private void addCustomStyling(NatTable natTable) {
        DefaultNatTableStyleConfiguration natTableConfiguration = new DefaultNatTableStyleConfiguration();
        natTableConfiguration.bgColor = GUIHelper.getColor((int)249, (int)172, (int)7);
        natTableConfiguration.fgColor = GUIHelper.getColor((int)30, (int)76, (int)19);
        natTableConfiguration.hAlign = HorizontalAlignmentEnum.LEFT;
        natTableConfiguration.vAlign = VerticalAlignmentEnum.TOP;
        natTableConfiguration.cellPainter = new PaddingDecorator((ICellPainter)new TextPainter(), 1);
        DefaultRowStyleConfiguration rowStyleConfiguration = new DefaultRowStyleConfiguration();
        rowStyleConfiguration.oddRowBgColor = GUIHelper.getColor((int)254, (int)251, (int)243);
        rowStyleConfiguration.evenRowBgColor = GUIHelper.COLOR_WHITE;
        DefaultSelectionStyleConfiguration selectionStyle = new DefaultSelectionStyleConfiguration();
        selectionStyle.selectionFont = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Verdana", 8, 0)});
        selectionStyle.selectionBgColor = GUIHelper.getColor((int)217, (int)232, (int)251);
        selectionStyle.selectionFgColor = GUIHelper.COLOR_BLACK;
        selectionStyle.anchorBorderStyle = new BorderStyle(1, GUIHelper.COLOR_DARK_GRAY, BorderStyle.LineStyleEnum.SOLID);
        selectionStyle.anchorBgColor = GUIHelper.getColor((int)65, (int)113, (int)43);
        selectionStyle.selectedHeaderBgColor = GUIHelper.getColor((int)156, (int)209, (int)103);
        natTable.addConfiguration((IConfiguration)natTableConfiguration);
        natTable.addConfiguration((IConfiguration)rowStyleConfiguration);
        natTable.addConfiguration((IConfiguration)selectionStyle);
        natTable.addConfiguration((IConfiguration)new StyledRowHeaderConfiguration());
        natTable.addConfiguration((IConfiguration)new StyledColumnHeaderConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
    }
}

