/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._800_Integration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.MultiLineTextCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.PasswordCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.FileDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.PasswordTextPainter;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class _804_GlazedListsEditorExample
extends AbstractNatExample {
    public static String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static String COLUMN_TWO_LABEL = "ColumnTwoLabel";
    public static String COLUMN_THREE_LABEL = "ColumnThreeLabel";
    public static String COLUMN_FOUR_LABEL = "ColumnFourLabel";
    public static String COLUMN_FIVE_LABEL = "ColumnFiveLabel";
    public static String COLUMN_SIX_LABEL = "ColumnSixLabel";
    public static String COLUMN_SEVEN_LABEL = "ColumnSevenLabel";
    public static String COLUMN_EIGHT_LABEL = "ColumnEightLabel";
    public static String COLUMN_NINE_LABEL = "ColumnNineLabel";
    public static String COLUMN_TEN_LABEL = "ColumnTenLabel";
    public static String COLUMN_ELEVEN_LABEL = "ColumnElevenLabel";
    public static String COLUMN_TWELVE_LABEL = "ColumnTwelveLabel";
    public static String COLUMN_THIRTEEN_LABEL = "ColumnThirteenLabel";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(1024, 400, new _804_GlazedListsEditorExample());
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "password", "description", "age", "money", "married", "gender", "address.street", "address.city", "favouriteFood", "favouriteDrinks", "filename"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("password", "Password");
        propertyToLabelMap.put("description", "Description");
        propertyToLabelMap.put("age", "Age");
        propertyToLabelMap.put("money", "Money");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("address.street", "Street");
        propertyToLabelMap.put("address.city", "City");
        propertyToLabelMap.put("favouriteFood", "Food");
        propertyToLabelMap.put("favouriteDrinks", "Drinks");
        propertyToLabelMap.put("filename", "Filename");
        ConfigRegistry configRegistry = new ConfigRegistry();
        GlazedListsGridEditorGridLayer gridLayer = new GlazedListsGridEditorGridLayer(PersonService.getExtendedPersonsWithAddress((int)10), configRegistry, propertyNames, propertyToLabelMap);
        DataLayer bodyDataLayer = gridLayer.getBodyDataLayer();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.registerColumnLabels(columnLabelAccumulator);
        NatTable natTable = new NatTable(parent, gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new EditorConfiguration());
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.configure();
        new NatTableContentTooltip(natTable, new String[]{"BODY"});
        return natTable;
    }

    private void registerColumnLabels(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_THREE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(3, new String[]{COLUMN_FOUR_LABEL});
        columnLabelAccumulator.registerColumnOverrides(4, new String[]{COLUMN_FIVE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(5, new String[]{COLUMN_SIX_LABEL});
        columnLabelAccumulator.registerColumnOverrides(6, new String[]{COLUMN_SEVEN_LABEL});
        columnLabelAccumulator.registerColumnOverrides(7, new String[]{COLUMN_EIGHT_LABEL});
        columnLabelAccumulator.registerColumnOverrides(8, new String[]{COLUMN_NINE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(9, new String[]{COLUMN_TEN_LABEL});
        columnLabelAccumulator.registerColumnOverrides(10, new String[]{COLUMN_ELEVEN_LABEL});
        columnLabelAccumulator.registerColumnOverrides(11, new String[]{COLUMN_TWELVE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(12, new String[]{COLUMN_THIRTEEN_LABEL});
    }

    class EditorConfiguration
    extends AbstractRegistryConfiguration {
        EditorConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
            this.registerEditors(configRegistry);
        }

        private void registerEditors(IConfigRegistry configRegistry) {
            this.registerColumnTwoTextEditor(configRegistry);
            this.registerColumnThreePasswordEditor(configRegistry);
            this.registerColumnFourMultiLineEditor(configRegistry);
            this.registerColumnFiveIntegerEditor(configRegistry);
            this.registerColumnSixDoubleEditor(configRegistry);
            this.registerColumnSevenCheckbox(configRegistry);
            this.registerColumnEightCheckbox(configRegistry);
            this.registerColumnNineComboBox(configRegistry);
            this.registerColumnTenComboBox(configRegistry);
            this.registerColumnElevenComboBox(configRegistry);
            this.registerColumnTwelveComboBox(configRegistry);
            this.registerColumnThirteenFileDialogEditor(configRegistry);
        }

        private void registerColumnTwoTextEditor(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(true, true), "NORMAL", COLUMN_TWO_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, (Object)Boolean.TRUE, "EDIT", COLUMN_TWO_LABEL);
            HashMap<String, String> editDialogSettings = new HashMap<String, String>();
            editDialogSettings.put("DIALOG_MESSAGE", "Please specify the lastname in here:");
            configRegistry.registerConfigAttribute(EditConfigAttributes.EDIT_DIALOG_SETTINGS, editDialogSettings, "EDIT", COLUMN_TWO_LABEL);
        }

        private void registerColumnThreePasswordEditor(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new PasswordCellEditor(), "NORMAL", COLUMN_THREE_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.SUPPORT_MULTI_EDIT, (Object)Boolean.FALSE, "EDIT", COLUMN_THREE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new PasswordTextPainter(), "NORMAL", COLUMN_THREE_LABEL);
        }

        private void registerColumnFourMultiLineEditor(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new MultiLineTextCellEditor(false), "NORMAL", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, (Object)Boolean.TRUE, "EDIT", COLUMN_FOUR_LABEL);
            Style cellStyle = new Style();
            cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "EDIT", COLUMN_FOUR_LABEL);
            Display display = Display.getCurrent();
            HashMap<String, Object> editDialogSettings = new HashMap<String, Object>();
            editDialogSettings.put("DIALOG_SHELL_TITLE", "My custom value");
            editDialogSettings.put("DIALOG_SHELL_ICON", display.getSystemImage(8));
            editDialogSettings.put("DIALOG_SHELL_RESIZABLE", Boolean.TRUE);
            Point size = new Point(400, 300);
            editDialogSettings.put("DIALOG_SHELL_SIZE", size);
            int screenWidth = display.getBounds().width;
            int screenHeight = display.getBounds().height;
            Point location = new Point(screenWidth / (2 * display.getMonitors().length) - size.x / 2, screenHeight / 2 - size.y / 2);
            editDialogSettings.put("DIALOG_SHELL_LOCATION", location);
            editDialogSettings.put("DIALOG_MESSAGE", "Enter some free text in here:");
            configRegistry.registerConfigAttribute(EditConfigAttributes.EDIT_DIALOG_SETTINGS, editDialogSettings, "EDIT", COLUMN_FOUR_LABEL);
        }

        private void registerColumnFiveIntegerEditor(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(false, true), "NORMAL", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, (Object)Boolean.TRUE, "EDIT", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, (Object)Boolean.TRUE, "EDIT", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL", COLUMN_FIVE_LABEL);
        }

        private void registerColumnSixDoubleEditor(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(false, true), "NORMAL", COLUMN_SIX_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, (Object)Boolean.TRUE, "EDIT", COLUMN_SIX_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, (Object)Boolean.TRUE, "EDIT", COLUMN_SIX_LABEL);
            configRegistry.registerConfigAttribute(TickUpdateConfigAttributes.USE_ADJUST_BY, (Object)Boolean.TRUE, "EDIT", COLUMN_SIX_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), "NORMAL", COLUMN_SIX_LABEL);
        }

        private void registerColumnSevenCheckbox(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "EDIT", COLUMN_SEVEN_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", COLUMN_SEVEN_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", COLUMN_SEVEN_LABEL);
        }

        private void registerColumnEightCheckbox(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "EDIT", COLUMN_EIGHT_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(GUIHelper.getImage((String)"arrow_up"), GUIHelper.getImage((String)"arrow_down")), "NORMAL", COLUMN_EIGHT_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)this.getGenderBooleanConverter(), "NORMAL", COLUMN_EIGHT_LABEL);
        }

        private void registerColumnNineComboBox(IConfigRegistry configRegistry) {
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getStreetNames()));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", COLUMN_NINE_LABEL);
        }

        private void registerColumnTenComboBox(IConfigRegistry configRegistry) {
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getCityNames()), -1);
            comboBoxCellEditor.setFreeEdit(true);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", COLUMN_TEN_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(), "NORMAL", COLUMN_TEN_LABEL);
        }

        private void registerColumnElevenComboBox(IConfigRegistry configRegistry) {
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getFoodList()), -1);
            comboBoxCellEditor.setMultiselect(true);
            comboBoxCellEditor.setUseCheckbox(true);
            comboBoxCellEditor.setMultiselectTextBracket("", "");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDisplayConverter(){

                public Object canonicalToDisplayValue(Object canonicalValue) {
                    if (canonicalValue instanceof Collection) {
                        String result = canonicalValue.toString();
                        result = result.substring(1, result.length() - 1);
                        return result;
                    }
                    return super.canonicalToDisplayValue(canonicalValue);
                }
            }, "NORMAL", COLUMN_ELEVEN_LABEL);
            comboBoxCellEditor.setIconImage(GUIHelper.getImage((String)"plus"));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", COLUMN_ELEVEN_LABEL);
        }

        private void registerColumnTwelveComboBox(IConfigRegistry configRegistry) {
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(Arrays.asList(PersonService.getDrinkList()), -1);
            comboBoxCellEditor.setFreeEdit(true);
            comboBoxCellEditor.setMultiselect(true);
            comboBoxCellEditor.setIconImage(GUIHelper.getImage((String)"plus"));
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", COLUMN_TWELVE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(GUIHelper.getImage((String)"plus")), "NORMAL", COLUMN_TWELVE_LABEL);
        }

        private void registerColumnThirteenFileDialogEditor(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new FileDialogCellEditor(), "EDIT", COLUMN_THIRTEEN_LABEL);
        }

        private IDisplayConverter getGenderBooleanConverter() {
            return new DisplayConverter(){

                public Object canonicalToDisplayValue(Object canonicalValue) {
                    if (canonicalValue instanceof Person.Gender) {
                        if ((Person.Gender)canonicalValue == Person.Gender.MALE) {
                            return true;
                        }
                        return false;
                    }
                    return null;
                }

                public Object displayToCanonicalValue(Object displayValue) {
                    Boolean displayBoolean = Boolean.valueOf(displayValue.toString());
                    return displayBoolean != false ? Person.Gender.MALE : Person.Gender.FEMALE;
                }
            };
        }
    }

    class GlazedListsEditorBodyLayerStack<T>
    extends AbstractLayerTransform {
        private final DataLayer bodyDataLayer;
        private final GlazedListsEventLayer<T> glazedListsEventLayer;
        private final ColumnReorderLayer columnReorderLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayer;
        private final EventList<T> eventList;
        private final TransformedList<T, T> rowObjectsGlazedList;
        private final SortedList<T> sortedList;
        private final FilterList<T> filterList;

        public GlazedListsEditorBodyLayerStack(Collection<T> valuesToShow, IColumnPropertyAccessor<T> cpa, ConfigRegistry configRegistry) {
            this.eventList = GlazedLists.eventList(valuesToShow);
            this.rowObjectsGlazedList = GlazedLists.threadSafeList(this.eventList);
            this.sortedList = new SortedList(this.rowObjectsGlazedList, null);
            this.filterList = new FilterList(this.sortedList);
            ListDataProvider dataProvider = new ListDataProvider(this.filterList, cpa);
            this.bodyDataLayer = new DataLayer((IDataProvider)dataProvider);
            this.glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, this.filterList);
            this.columnReorderLayer = new ColumnReorderLayer(this.glazedListsEventLayer);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)this.viewportLayer);
            this.registerCommandHandler((ILayerCommandHandler)new CopyDataCommandHandler(this.selectionLayer));
        }

        public DataLayer getDataLayer() {
            return this.bodyDataLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    public class GlazedListsEditorColumnHeaderLayerStack<T>
    extends AbstractLayerTransform {
        public GlazedListsEditorColumnHeaderLayerStack(IDataProvider dataProvider, GlazedListsEditorBodyLayerStack<T> bodyLayerStack, IColumnPropertyAccessor<T> columnPropertyAccessor, IConfigRegistry configRegistry) {
            DefaultColumnHeaderDataLayer dataLayer = new DefaultColumnHeaderDataLayer(dataProvider);
            ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)dataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
            SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(((GlazedListsEditorBodyLayerStack)bodyLayerStack).sortedList, columnPropertyAccessor, configRegistry, (ILayer)dataLayer), false);
            FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(((GlazedListsEditorBodyLayerStack)bodyLayerStack).filterList, columnPropertyAccessor, configRegistry), (ILayer)sortHeaderLayer, dataProvider, configRegistry);
            this.setUnderlyingLayer((ILayer)filterRowHeaderLayer);
        }
    }

    class GlazedListsGridEditorGridLayer<T>
    extends GridLayer {
        public GlazedListsGridEditorGridLayer(Collection<T> valuesToShow, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap) {
            super(true);
            this.init(valuesToShow, configRegistry, propertyNames, propertyToLabelMap);
        }

        private void init(Collection<T> valuesToShow, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap) {
            ExtendedReflectiveColumnPropertyAccessor columnAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
            GlazedListsEditorBodyLayerStack<T> bodyLayer = new GlazedListsEditorBodyLayerStack<T>(valuesToShow, columnAccessor, configRegistry);
            SelectionLayer selectionLayer = bodyLayer.getSelectionLayer();
            DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
            GlazedListsEditorColumnHeaderLayerStack<T> columnHeaderLayer = new GlazedListsEditorColumnHeaderLayerStack<T>((IDataProvider)columnHeaderDataProvider, bodyLayer, columnAccessor, (IConfigRegistry)configRegistry);
            DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayer.getDataLayer().getDataProvider());
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider), bodyLayer, selectionLayer);
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, columnHeaderLayer);
            this.setBodyLayer((ILayer)bodyLayer);
            this.setColumnHeaderLayer((ILayer)columnHeaderLayer);
            this.setRowHeaderLayer((ILayer)rowHeaderLayer);
            this.setCornerLayer((ILayer)cornerLayer);
        }

        public DataLayer getBodyDataLayer() {
            return ((GlazedListsEditorBodyLayerStack)this.getBodyLayer()).getDataLayer();
        }
    }
}

