/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._400_Configuration._440_Editing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.EventData;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples._400_Configuration._440_Editing.CrossValidationEditConfiguration;
import org.eclipse.nebula.widgets.nattable.examples._400_Configuration._440_Editing.CrossValidationLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _4451_CrossValidationGridExample
extends AbstractNatExample {
    public static String DATE_LABEL = "DateLabel";
    public static String INVALID_LABEL = "InvalidLabel";
    private EventList<EventData> valuesToShow = GlazedLists.eventList(new ArrayList());

    public static void main(String[] args) throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        StandaloneNatExampleRunner.run(new _4451_CrossValidationGridExample());
    }

    @Override
    public String getDescription() {
        return "Demonstrates how to implement an editable grid with cross validation.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonPanel);
        String[] propertyNames = new String[]{"title", "description", "where", "fromDate", "toDate"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("title", "Title");
        propertyToLabelMap.put("description", "Description");
        propertyToLabelMap.put("where", "Where");
        propertyToLabelMap.put("fromDate", "From");
        propertyToLabelMap.put("toDate", "To");
        this.valuesToShow.addAll(this.createEventData());
        ConfigRegistry configRegistry = new ConfigRegistry();
        DefaultGridLayer gridLayer = new DefaultGridLayer(this.valuesToShow, propertyNames, propertyToLabelMap);
        DataLayer bodyDataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        IRowDataProvider bodyDataProvider = (IRowDataProvider)bodyDataLayer.getDataProvider();
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new CrossValidationLabelAccumulator((IRowDataProvider<EventData>)bodyDataProvider));
        NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new CrossValidationEditConfiguration((IRowDataProvider<EventData>)bodyDataProvider));
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        return panel;
    }

    private List<EventData> createEventData() {
        ArrayList<EventData> result = new ArrayList<EventData>();
        EventData ed = new EventData();
        ed.setTitle("My correct event");
        ed.setDescription("My event that validates correctly");
        ed.setWhere("Somewhere");
        ed.setFromDate(new GregorianCalendar(2013, 2, 1).getTime());
        ed.setToDate(new GregorianCalendar(2013, 2, 3).getTime());
        result.add(ed);
        ed = new EventData();
        ed.setTitle("My wrong event");
        ed.setDescription("My event where validation fails");
        ed.setWhere("Somewhere else");
        ed.setFromDate(new GregorianCalendar(2013, 2, 3).getTime());
        ed.setToDate(new GregorianCalendar(2013, 2, 1).getTime());
        result.add(ed);
        return result;
    }

    public static boolean isEventDataValid(EventData event) {
        return event.getFromDate().before(event.getToDate());
    }

    public static boolean isEventDataValid(Date fromDate, Date toDate) {
        return fromDate.before(toDate);
    }
}

