/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByModel
extends Observable {
    private List<Integer> groupByColumnIndexes = new ArrayList<Integer>();
    private Map<Integer, SortDirectionEnum> sortDirectionMap = new HashMap<Integer, SortDirectionEnum>();

    public boolean addGroupByColumnIndex(int columnIndex) {
        if (!this.groupByColumnIndexes.contains(columnIndex)) {
            this.groupByColumnIndexes.add(columnIndex);
            this.setChanged();
            this.notifyObservers();
            return true;
        }
        return false;
    }

    public boolean removeGroupByColumnIndex(int columnIndex) {
        if (this.groupByColumnIndexes.contains(columnIndex)) {
            this.groupByColumnIndexes.remove((Object)columnIndex);
            this.sortDirectionMap.remove(columnIndex);
            this.setChanged();
            this.notifyObservers();
            return true;
        }
        return false;
    }

    public void clearGroupByColumnIndexes() {
        this.groupByColumnIndexes.clear();
        this.sortDirectionMap.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public List<Integer> getGroupByColumnIndexes() {
        return this.groupByColumnIndexes;
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.sortDirectionMap.get(columnIndex);
    }
}

