/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TreeList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByTreeFormat;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByDataLayer<T>
extends DataLayer
implements Observer {
    public static final String GROUP_BY_OBJECT = "GROUP_BY_OBJECT";
    private final GroupByModel groupByModel;
    private final EventList<T> eventList;
    private final IColumnAccessor<T> columnAccessor;
    private final TreeList.ExpansionModel<Object> treeExpansionModel;
    private final GlazedListTreeData<Object> treeData;
    private final GlazedListTreeRowModel<Object> treeRowModel;
    private final GroupByDataProvider groupByDataProvider;

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor) {
        this.groupByModel = groupByModel;
        this.eventList = eventList;
        this.columnAccessor = columnAccessor;
        groupByModel.addObserver(this);
        this.treeExpansionModel = new TreeList.ExpansionModel<Object>(){

            public boolean isExpanded(Object arg0, List<Object> arg1) {
                return true;
            }

            public void setExpanded(Object arg0, List<Object> arg1, boolean arg2) {
            }
        };
        this.treeData = new GlazedListTreeData(null);
        GroupByTreeFormat<T> treeFormat = new GroupByTreeFormat<T>(groupByModel, columnAccessor);
        TreeList treeList = new TreeList(eventList, treeFormat, this.treeExpansionModel);
        this.treeData.setTreeList((TreeList<Object>)treeList);
        this.treeRowModel = new GlazedListTreeRowModel<Object>(this.treeData);
        GroupByColumnAccessor<T> groupByColumnAccessor = new GroupByColumnAccessor<T>(columnAccessor);
        this.groupByDataProvider = new GroupByDataProvider((EventList<Object>)treeList, groupByColumnAccessor);
        this.setDataProvider((IDataProvider)this.groupByDataProvider);
        this.addConfiguration((IConfiguration)new GroupByDataLayerConfiguration());
    }

    private void resetTreeList() {
        GroupByTreeFormat<T> treeFormat = new GroupByTreeFormat<T>(this.groupByModel, this.columnAccessor);
        TreeList treeList = new TreeList(this.eventList, treeFormat, this.treeExpansionModel);
        this.treeData.setTreeList((TreeList<Object>)treeList);
        this.groupByDataProvider.setList((List<Object>)treeList);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.resetTreeList();
        this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)this));
    }

    public GlazedListTreeRowModel<Object> getTreeRowModel() {
        return this.treeRowModel;
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.treeData.getDataAtIndex(this.getRowIndexByPosition(rowPosition)) instanceof GroupByObject) {
            configLabels.addLabel(GROUP_BY_OBJECT);
        }
        return configLabels;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupByDataProvider
    extends GlazedListsDataProvider<Object> {
        public GroupByDataProvider(EventList<Object> list, IColumnAccessor<Object> columnAccessor) {
            super(list, columnAccessor);
        }

        public void setList(List<Object> list) {
            this.list = list;
        }
    }
}

