/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.matchers.ThresholdMatcherEditor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.FilterRowUtils;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.ParseResult;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGlazedListsFilterStrategy<T>
implements IFilterStrategy<T> {
    private final IColumnAccessor<T> columnAccessor;
    private final IConfigRegistry configRegistry;
    protected final CompositeMatcherEditor<T> matcherEditor;

    public DefaultGlazedListsFilterStrategy(CompositeMatcherEditor<T> matcherEditor, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        this.columnAccessor = columnAccessor;
        this.configRegistry = configRegistry;
        this.matcherEditor = matcherEditor;
    }

    public void applyFilter(Map<Integer, Object> filterObjectByIndex) {
        try {
            this.matcherEditor.getMatcherEditors().clear();
            if (filterObjectByIndex.isEmpty()) {
                return;
            }
            BasicEventList matcherEditors = new BasicEventList();
            for (Map.Entry<Integer, Object> mapEntry : filterObjectByIndex.entrySet()) {
                Integer columnIndex = mapEntry.getKey();
                String filterText = this.getStringFromColumnObject(columnIndex, mapEntry.getValue());
                String textDelimiter = (String)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                TextMatchingMode textMatchingMode = (TextMatchingMode)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                Comparator comparator = (Comparator)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                FunctionList.Function<T, Object> columnValueProvider = this.getColumnValueProvider(columnIndex);
                List<ParseResult> parseResults = FilterRowUtils.parse(filterText, textDelimiter, textMatchingMode);
                BasicEventList stringMatcherEditors = new BasicEventList();
                for (ParseResult parseResult : parseResults) {
                    ParseResult.MatchType matchOperation = parseResult.getMatchOperation();
                    if (matchOperation == ParseResult.MatchType.NONE) {
                        stringMatcherEditors.add(this.getTextMatcherEditor(columnIndex, textMatchingMode, displayConverter, parseResult.getValueToMatch()));
                        continue;
                    }
                    Object threshold = displayConverter.displayToCanonicalValue((Object)parseResult.getValueToMatch());
                    matcherEditors.add(this.getThresholdMatcherEditor(columnIndex, threshold, comparator, columnValueProvider, matchOperation));
                }
                if (stringMatcherEditors.size() <= 0) continue;
                CompositeMatcherEditor stringCompositeMatcherEditor = new CompositeMatcherEditor((EventList)stringMatcherEditors);
                stringCompositeMatcherEditor.setMode(24);
                matcherEditors.add((Object)stringCompositeMatcherEditor);
            }
            this.matcherEditor.getMatcherEditors().addAll((Collection)matcherEditors);
            this.matcherEditor.setMode(42);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private String getStringFromColumnObject(int columnIndex, Object object) {
        IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
        return displayConverter.canonicalToDisplayValue(object).toString();
    }

    protected ThresholdMatcherEditor<T, Object> getThresholdMatcherEditor(Integer columnIndex, Object threshold, Comparator<Object> comparator, FunctionList.Function<T, Object> columnValueProvider, ParseResult.MatchType matchOperation) {
        ThresholdMatcherEditor thresholdMatcherEditor = new ThresholdMatcherEditor(threshold, null, comparator, columnValueProvider);
        FilterRowUtils.setMatchOperation(thresholdMatcherEditor, matchOperation);
        return thresholdMatcherEditor;
    }

    protected FunctionList.Function<T, Object> getColumnValueProvider(final int columnIndex) {
        return new FunctionList.Function<T, Object>(){

            public Object evaluate(T rowObject) {
                return DefaultGlazedListsFilterStrategy.this.columnAccessor.getDataValue(rowObject, columnIndex);
            }
        };
    }

    protected TextMatcherEditor<T> getTextMatcherEditor(Integer columnIndex, TextMatchingMode textMatchingMode, IDisplayConverter converter, String filterText) {
        TextMatcherEditor textMatcherEditor = new TextMatcherEditor(this.getTextFilterator(columnIndex, converter));
        textMatcherEditor.setFilterText(new String[]{filterText});
        textMatcherEditor.setMode(this.getGlazedListsTextMatcherEditorMode(textMatchingMode));
        return textMatcherEditor;
    }

    protected TextFilterator<T> getTextFilterator(final Integer columnIndex, final IDisplayConverter converter) {
        return new TextFilterator<T>(){

            public void getFilterStrings(List<String> objectAsListOfStrings, T rowObject) {
                Object cellData = DefaultGlazedListsFilterStrategy.this.columnAccessor.getDataValue(rowObject, columnIndex.intValue());
                Object displayValue = converter.canonicalToDisplayValue(cellData);
                displayValue = ObjectUtils.isNotNull((Object)displayValue) ? displayValue : "";
                objectAsListOfStrings.add(displayValue.toString());
            }
        };
    }

    public int getGlazedListsTextMatcherEditorMode(TextMatchingMode textMatchingMode) {
        switch (textMatchingMode) {
            case EXACT: {
                return 3;
            }
            case STARTS_WITH: {
                return 1;
            }
            case REGULAR_EXPRESSION: {
                return 2;
            }
        }
        return 0;
    }
}

