/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.matcher;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellPainterMouseEventMatcher
extends MouseEventMatcher {
    private ICellPainter targetCellPainter;
    private Class<? extends ICellPainter> targetCellPainterClass;

    public CellPainterMouseEventMatcher(String regionName, int button, ICellPainter targetCellPainter) {
        super(regionName, button);
        this.targetCellPainter = targetCellPainter;
    }

    public CellPainterMouseEventMatcher(String regionName, int button, Class<? extends ICellPainter> targetCellPainterClass) {
        super(regionName, button);
        this.targetCellPainterClass = targetCellPainterClass;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        if (super.matches(natTable, event, regionLabels)) {
            int columnPosition = natTable.getColumnPositionByX(event.x);
            int rowPosition = natTable.getRowPositionByY(event.y);
            ILayerCell cell = natTable.getCellByPosition(columnPosition, rowPosition);
            IConfigRegistry configRegistry = natTable.getConfigRegistry();
            ICellPainter cellPainter = cell.getLayer().getCellPainter(columnPosition, rowPosition, cell, configRegistry);
            GC gc = new GC((Drawable)natTable.getDisplay());
            try {
                Rectangle adjustedCellBounds = natTable.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, cell.getBounds());
                ICellPainter clickedCellPainter = cellPainter.getCellPainterAt(event.x, event.y, cell, gc, adjustedCellBounds, configRegistry);
                if (clickedCellPainter != null && (this.targetCellPainter != null && this.targetCellPainter == clickedCellPainter || this.targetCellPainterClass != null && this.targetCellPainterClass.isInstance(clickedCellPainter))) {
                    return true;
                }
            }
            finally {
                gc.dispose();
            }
        }
        return false;
    }
}

