/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.action;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.swt.events.MouseEvent;

public class AggregateDragMode
implements IDragMode {
    private MouseEvent initialEvent;
    private MouseEvent currentEvent;
    private final Collection<IDragMode> dragModes = new LinkedHashSet<IDragMode>();

    public AggregateDragMode() {
    }

    public AggregateDragMode(IDragMode ... dragModes) {
        IDragMode[] iDragModeArray = dragModes;
        int n = dragModes.length;
        int n2 = 0;
        while (n2 < n) {
            IDragMode dragMode = iDragModeArray[n2];
            this.addDragMode(dragMode);
            ++n2;
        }
    }

    public void addDragMode(IDragMode dragMode) {
        this.dragModes.add(dragMode);
    }

    public void removeDragMode(IDragMode dragMode) {
        this.dragModes.remove(dragMode);
    }

    public void mouseDown(NatTable natTable, MouseEvent event) {
        this.currentEvent = this.initialEvent = event;
        for (IDragMode dragMode : this.dragModes) {
            dragMode.mouseDown(natTable, event);
        }
        natTable.forceFocus();
    }

    public void mouseMove(NatTable natTable, MouseEvent event) {
        this.currentEvent = event;
        for (IDragMode dragMode : this.dragModes) {
            dragMode.mouseMove(natTable, event);
        }
    }

    public void mouseUp(NatTable natTable, MouseEvent event) {
        for (IDragMode dragMode : this.dragModes) {
            dragMode.mouseUp(natTable, event);
        }
    }

    protected MouseEvent getInitialEvent() {
        return this.initialEvent;
    }

    protected MouseEvent getCurrentEvent() {
        return this.currentEvent;
    }
}

