/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeImagePainter
extends ImagePainter {
    private final ITreeRowModel<?> treeRowModel;
    private final Image plusImage;
    private final Image minusImage;
    private final Image leafImage;

    public TreeImagePainter(ITreeRowModel<?> treeRowModel) {
        this(treeRowModel, GUIHelper.getImage("plus"), GUIHelper.getImage("minus"), GUIHelper.getImage("leaf"));
    }

    public TreeImagePainter(ITreeRowModel<?> treeRowModel, Image plusImage, Image minusImage, Image leafImage) {
        super(null, false);
        this.treeRowModel = treeRowModel;
        this.plusImage = plusImage;
        this.minusImage = minusImage;
        this.leafImage = leafImage;
    }

    public Image getPlusImage() {
        return this.plusImage;
    }

    public Image getMinusImage() {
        return this.minusImage;
    }

    public Image getLeafImage() {
        return this.leafImage;
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        int index = cell.getLayer().getRowIndexByPosition(cell.getRowPosition());
        return !this.treeRowModel.hasChildren(index) ? this.leafImage : (this.treeRowModel.isCollapsed(index) ? this.plusImage : this.minusImage);
    }
}

