/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.util.ComparatorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableTreeComparator<T>
implements Comparator<T> {
    private final Comparator<T> treeComparator;
    private final ISortModel sortModel;

    public SortableTreeComparator(Comparator<T> treeComparator, ISortModel sortModel) {
        this.treeComparator = treeComparator;
        this.sortModel = sortModel;
    }

    @Override
    public int compare(T o1, T o2) {
        int treeComparatorResult = this.treeComparator.compare(o1, o2);
        if (treeComparatorResult == 0) {
            return 0;
        }
        List<Integer> sortedColumnIndexes = this.sortModel.getSortedColumnIndexes();
        if (sortedColumnIndexes != null && sortedColumnIndexes.size() > 0) {
            ArrayList comparators = new ArrayList();
            for (int sortedColumnIndex : sortedColumnIndexes) {
                List<Comparator> columnComparators = this.sortModel.getComparatorsForColumnIndex(sortedColumnIndex);
                if (columnComparators == null) continue;
                SortDirectionEnum sortDirection = this.sortModel.getSortDirection(sortedColumnIndex);
                for (Comparator columnComparator : columnComparators) {
                    switch (sortDirection) {
                        case ASC: {
                            comparators.add(columnComparator);
                            break;
                        }
                        case DESC: {
                            comparators.add(Collections.reverseOrder(columnComparator));
                        }
                    }
                }
            }
            return new ComparatorChain<T>(comparators).compare(o1, o2);
        }
        return treeComparatorResult;
    }
}

