/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCellCommandHandler
implements ILayerCommandHandler<SelectCellCommand> {
    private final SelectionLayer selectionLayer;

    public SelectCellCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectCellCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.toggleCell(command.getColumnPosition(), command.getRowPosition(), command.isShiftMask(), command.isControlMask(), command.isForcingEntireCellIntoViewport());
            this.selectionLayer.fireCellSelectionEvent(command.getColumnPosition(), command.getRowPosition(), command.isForcingEntireCellIntoViewport(), command.isShiftMask(), command.isControlMask());
            return true;
        }
        return false;
    }

    protected void toggleCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask, boolean forcingEntireCellIntoViewport) {
        boolean selectCell = true;
        if (SelectionUtils.isControlOnly(withShiftMask, withControlMask) && this.selectionLayer.isCellPositionSelected(columnPosition, rowPosition)) {
            ILayerCell cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition);
            Rectangle cellRect = new Rectangle(cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnSpan(), cell.getRowSpan());
            this.selectionLayer.clearSelection(cellRect);
            selectCell = false;
        }
        if (selectCell) {
            this.selectCell(columnPosition, rowPosition, withShiftMask, withControlMask);
        }
    }

    public void selectCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        if (!withShiftMask && !withControlMask) {
            this.selectionLayer.clear(false);
        }
        ILayerCell cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition);
        this.selectionLayer.setLastSelectedCell(cell.getOriginColumnPosition(), cell.getOriginRowPosition());
        if (withShiftMask && this.selectionLayer.lastSelectedRegion != null && this.selectionLayer.hasRowSelection()) {
            if (cell.getRowPosition() > this.selectionLayer.selectionAnchor.rowPosition) {
                int maxRowPosition = cell.getOriginRowPosition() + cell.getRowSpan() - 1;
                this.selectionLayer.lastSelectedRegion.height = Math.abs(this.selectionLayer.selectionAnchor.rowPosition - maxRowPosition) + 1;
            } else {
                int minRowPosition = cell.getOriginRowPosition();
                this.selectionLayer.lastSelectedRegion.height = Math.abs(this.selectionLayer.selectionAnchor.rowPosition - minRowPosition) + 1;
            }
            this.selectionLayer.lastSelectedRegion.y = Math.min(this.selectionLayer.selectionAnchor.rowPosition, cell.getOriginRowPosition());
            if (cell.getColumnPosition() > this.selectionLayer.selectionAnchor.columnPosition) {
                int maxColumnPosition = cell.getOriginColumnPosition() + cell.getColumnSpan() - 1;
                this.selectionLayer.lastSelectedRegion.width = Math.abs(this.selectionLayer.selectionAnchor.columnPosition - maxColumnPosition) + 1;
            } else {
                int minColumnPosition = cell.getOriginColumnPosition();
                this.selectionLayer.lastSelectedRegion.width = Math.abs(this.selectionLayer.selectionAnchor.columnPosition - minColumnPosition) + 1;
            }
            this.selectionLayer.lastSelectedRegion.x = Math.min(this.selectionLayer.selectionAnchor.columnPosition, cell.getOriginColumnPosition());
            this.selectionLayer.addSelection(this.selectionLayer.lastSelectedRegion);
        } else {
            this.selectionLayer.lastSelectedRegion = null;
            Rectangle selection = new Rectangle(cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnSpan(), cell.getRowSpan());
            this.selectionLayer.addSelection(selection);
        }
    }

    @Override
    public Class<SelectCellCommand> getCommandClass() {
        return SelectCellCommand.class;
    }
}

