/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.RowObjectIndexHolder;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSelectionProvider<T>
implements ISelectionProvider,
ILayerListener {
    private SelectionLayer selectionLayer;
    private final IRowDataProvider<T> rowDataProvider;
    private final boolean fullySelectedRowsOnly;
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private ISelection previousSelection;

    public RowSelectionProvider(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        this(selectionLayer, rowDataProvider, true);
    }

    public RowSelectionProvider(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider, boolean fullySelectedRowsOnly) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.fullySelectedRowsOnly = fullySelectedRowsOnly;
        selectionLayer.addLayerListener(this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return RowSelectionProvider.populateRowSelection(this.selectionLayer, this.rowDataProvider, this.fullySelectedRowsOnly);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.selectionLayer != null && selection instanceof IStructuredSelection) {
            this.selectionLayer.clear();
            if (!selection.isEmpty()) {
                List rowObjects = ((IStructuredSelection)selection).toList();
                HashSet<Integer> rowPositions = new HashSet<Integer>();
                for (Object rowObject : rowObjects) {
                    int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
                    int rowPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
                    rowPositions.add(rowPosition);
                }
                int intValue = -1;
                if (!rowPositions.isEmpty()) {
                    Integer max = (Integer)Collections.max(rowPositions);
                    intValue = max;
                }
                if (intValue >= 0) {
                    this.selectionLayer.doCommand(new SelectRowsCommand((ILayer)this.selectionLayer, 0, ObjectUtils.asIntArray(rowPositions), false, true, intValue));
                }
            }
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        ISelection selection;
        if (event instanceof ISelectionEvent && !(selection = this.getSelection()).equals(this.previousSelection)) {
            try {
                for (ISelectionChangedListener listener : this.listeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                }
            }
            finally {
                this.previousSelection = selection;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static StructuredSelection populateRowSelection(SelectionLayer selectionLayer, IRowDataProvider rowDataProvider, boolean fullySelectedRowsOnly) {
        ArrayList<RowObjectIndexHolder<Object>> rows = new ArrayList<RowObjectIndexHolder<Object>>();
        if (selectionLayer != null) {
            if (fullySelectedRowsOnly) {
                void var5_10;
                int[] nArray = selectionLayer.getFullySelectedRowPositions();
                int n = nArray.length;
                boolean n2 = false;
                while (var5_10 < n) {
                    int rowPosition = nArray[var5_10];
                    RowSelectionProvider.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                    ++var5_10;
                }
            } else {
                Set<Range> rowRanges = selectionLayer.getSelectedRowPositions();
                for (Range range : rowRanges) {
                    int rowPosition = range.start;
                    while (rowPosition < range.end) {
                        RowSelectionProvider.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                        ++rowPosition;
                    }
                }
            }
        }
        Collections.sort(rows);
        ArrayList rowObjects = new ArrayList();
        for (RowObjectIndexHolder rowObjectIndexHolder : rows) {
            rowObjects.add(rowObjectIndexHolder.getRow());
        }
        return rows.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection(rowObjects);
    }

    private static void addToSelection(List<RowObjectIndexHolder<Object>> rows, int rowPosition, SelectionLayer selectionLayer, IRowDataProvider rowDataProvider) {
        int rowIndex = selectionLayer.getRowIndexByPosition(rowPosition);
        if (rowIndex >= 0 && rowIndex < rowDataProvider.getRowCount()) {
            Object rowObject = rowDataProvider.getRowObject(rowIndex);
            rows.add(new RowObjectIndexHolder(rowIndex, rowObject));
        }
    }
}

