/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowPostSelectionProvider<T>
extends RowSelectionProvider<T>
implements IPostSelectionProvider {
    private ListenerList postSelectionChangedListeners = new ListenerList();
    private ISelection previousSelection;

    public RowPostSelectionProvider(NatTable natTable, SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        super(selectionLayer, rowDataProvider);
        this.hookControl((Control)natTable);
    }

    public RowPostSelectionProvider(NatTable natTable, SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider, boolean fullySelectedRowsOnly) {
        super(selectionLayer, rowDataProvider, fullySelectedRowsOnly);
        this.hookControl((Control)natTable);
    }

    protected void hookControl(Control control) {
        OpenStrategy handler = new OpenStrategy(control);
        handler.addPostSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowPostSelectionProvider.this.handlePostSelect(e);
            }
        });
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.remove((Object)listener);
    }

    protected void handlePostSelect(SelectionEvent e) {
        ISelection selection = this.getSelection();
        if (!selection.equals(this.previousSelection)) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            this.firePostSelectionChanged(event);
            this.previousSelection = selection;
        }
    }

    protected void firePostSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.postSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }
}

