/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.selection.MoveCellSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class MoveRowSelectionCommandHandler
extends MoveCellSelectionCommandHandler {
    public MoveRowSelectionCommandHandler(SelectionLayer selectionLayer) {
        super(selectionLayer);
    }

    protected void moveLastSelectedLeft(int stepSize, boolean withShiftMask, boolean withControlMask) {
        super.moveLastSelectedLeft(stepSize, withShiftMask, withControlMask);
        if (this.lastSelectedCellPosition != null) {
            this.selectionLayer.selectRow(this.newSelectedColumnPosition, this.lastSelectedCellPosition.rowPosition, withShiftMask, withControlMask);
        }
    }

    protected void moveLastSelectedRight(int stepSize, boolean withShiftMask, boolean withControlMask) {
        super.moveLastSelectedRight(stepSize, withShiftMask, withControlMask);
        if (this.lastSelectedCellPosition != null) {
            this.selectionLayer.selectRow(this.lastSelectedCellPosition.columnPosition, this.lastSelectedCellPosition.rowPosition, withShiftMask, withControlMask);
        }
    }

    protected void moveLastSelectedUp(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            int newSelectedRowPosition;
            PositionCoordinate lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int n = newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.rowPosition - stepSize : 0;
            if (newSelectedRowPosition < 0) {
                newSelectedRowPosition = 0;
            }
            this.selectionLayer.selectRow(lastSelectedCell.columnPosition, newSelectedRowPosition, withShiftMask, withControlMask);
        }
    }

    protected void moveLastSelectedDown(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            int newSelectedRowPosition;
            PositionCoordinate lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int n = newSelectedRowPosition = stepSize >= 0 ? lastSelectedCell.rowPosition + stepSize : this.selectionLayer.getRowCount() - 1;
            if (newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
            }
            this.selectionLayer.selectRow(lastSelectedCell.columnPosition, newSelectedRowPosition, withShiftMask, withControlMask);
        }
    }
}

