/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellLayerPainter
implements ILayerPainter {
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        if (pixelRectangle.width <= 0 || pixelRectangle.height <= 0) {
            return;
        }
        HashSet<ILayerCell> spannedCells = new HashSet<ILayerCell>();
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        int columnPosition = positionRectangle.x;
        while (columnPosition < positionRectangle.x + positionRectangle.width) {
            int rowPosition = positionRectangle.y;
            while (rowPosition < positionRectangle.y + positionRectangle.height) {
                ILayerCell cell = natLayer.getCellByPosition(columnPosition, rowPosition);
                if (cell != null) {
                    if (cell.isSpannedCell()) {
                        spannedCells.add(cell);
                    } else {
                        this.paintCell(cell, gc, configRegistry);
                    }
                }
                ++rowPosition;
            }
            ++columnPosition;
        }
        for (ILayerCell cell : spannedCells) {
            this.paintCell(cell, gc, configRegistry);
        }
    }

    public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle cellBounds) {
        return cellBounds;
    }

    protected Rectangle getPositionRectangleFromPixelRectangle(ILayer natLayer, Rectangle pixelRectangle) {
        int columnPositionOffset = natLayer.getColumnPositionByX(pixelRectangle.x);
        int rowPositionOffset = natLayer.getRowPositionByY(pixelRectangle.y);
        int numColumns = natLayer.getColumnPositionByX(Math.min(natLayer.getWidth(), pixelRectangle.x + pixelRectangle.width) - 1) - columnPositionOffset + 1;
        int numRows = natLayer.getRowPositionByY(Math.min(natLayer.getHeight(), pixelRectangle.y + pixelRectangle.height) - 1) - rowPositionOffset + 1;
        return new Rectangle(columnPositionOffset, rowPositionOffset, numColumns, numRows);
    }

    protected void paintCell(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        ICellPainter cellPainter = cell.getLayer().getCellPainter(cell.getColumnPosition(), cell.getRowPosition(), cell, configRegistry);
        Rectangle adjustedCellBounds = cell.getLayer().getLayerPainter().adjustCellBounds(cell.getColumnPosition(), cell.getRowPosition(), cell.getBounds());
        if (cellPainter != null) {
            cellPainter.paintCell(cell, gc, adjustedCellBounds, configRegistry);
        }
    }
}

