/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.GraphicsUtils;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class VerticalTextPainter
extends AbstractTextPainter {
    public VerticalTextPainter() {
        this(false, true);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, 0);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        this(wrapText, paintBg, 0, calculate);
    }

    public VerticalTextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return gc.textExtent((String)this.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry)).x;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return this.getLengthFromCache(gc, this.convertDataType(cell, configRegistry)) + this.spacing * 2 + 1;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        if (this.paintBg) {
            super.paintCell(cell, gc, rectangle, configRegistry);
        }
        Rectangle originalClipping = gc.getClipping();
        gc.setClipping(rectangle.intersection(originalClipping));
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        this.setupGCFromConfig(gc, cellStyle);
        String text = this.convertDataType(cell, configRegistry);
        text = this.getTextToDisplay(cell, gc, rectangle.height, text);
        int numberOfNewLines = this.getNumberOfNewLines(text);
        int fontHeight = gc.getFontMetrics().getHeight();
        int contentWidth = fontHeight * numberOfNewLines;
        int contentToCellDiff = cell.getBounds().width - rectangle.width;
        if (contentWidth > rectangle.width && this.calculate) {
            ILayer layer = cell.getLayer();
            layer.doCommand(new ColumnResizeCommand(layer, cell.getColumnPosition(), contentWidth + this.spacing * 2 + contentToCellDiff));
        }
        if (text != null && text.length() > 0) {
            if (numberOfNewLines == 1) {
                int contentHeight = Math.min(this.getLengthFromCache(gc, text), rectangle.height);
                GraphicsUtils.drawVerticalText(text, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentWidth) + this.spacing, rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight + this.spacing), this.underline, this.strikethrough, this.paintBg, gc, 128);
            } else {
                String[] lines;
                int xStartPos = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentWidth);
                String[] stringArray = lines = text.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.width);
                    GraphicsUtils.drawVerticalText(line, xStartPos + this.spacing, rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, lineContentWidth + this.spacing), this.underline, this.strikethrough, this.paintBg, gc, 128);
                    xStartPos += fontHeight;
                    ++n2;
                }
            }
        }
        gc.setClipping(originalClipping);
    }

    protected void setNewMinLength(ILayerCell cell, int contentHeight) {
        int cellLength = cell.getBounds().height;
        if (cellLength < contentHeight) {
            ILayer layer = cell.getLayer();
            int row = layer.getRowIndexByPosition(cell.getRowPosition());
            layer.doCommand(new RowResizeCommand(layer, row, contentHeight));
        }
    }

    protected int calculatePadding(ILayerCell cell, int availableLength) {
        return cell.getBounds().height - availableLength;
    }
}

