/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.MaxCellBoundsHelper;
import org.eclipse.nebula.widgets.nattable.resize.command.AutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoResizeRowCommandHandler
implements ILayerCommandHandler<AutoResizeRowsCommand> {
    private final GridLayer gridLayer;

    public AutoResizeRowCommandHandler(GridLayer gridLayer) {
        this.gridLayer = gridLayer;
    }

    @Override
    public Class<AutoResizeRowsCommand> getCommandClass() {
        return AutoResizeRowsCommand.class;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, AutoResizeRowsCommand command) {
        targetLayer.doCommand(new TurnViewportOffCommand());
        int[] rowPositions = ObjectUtils.asIntArray(command.getRowPositions());
        int[] gridRowPositions = this.convertFromSelectionToGrid(rowPositions);
        int[] gridRowHeights = MaxCellBoundsHelper.getPreferedRowHeights(command.getConfigRegistry(), command.getGCFactory(), this.gridLayer, gridRowPositions);
        this.gridLayer.doCommand(new MultiRowResizeCommand((ILayer)this.gridLayer, gridRowPositions, gridRowHeights));
        targetLayer.doCommand(new TurnViewportOnCommand());
        return true;
    }

    private int[] convertFromSelectionToGrid(int[] rowPositions) {
        int[] gridRowPositions = new int[rowPositions.length];
        int i = 0;
        while (i < rowPositions.length) {
            gridRowPositions[i] = this.gridLayer.underlyingToLocalRowPosition(this.gridLayer.getBodyLayer(), rowPositions[i]);
            ++i;
        }
        return gridRowPositions;
    }
}

