/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze.command;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCoordinatesProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

class FreezeSelectionStrategy
implements IFreezeCoordinatesProvider {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;

    FreezeSelectionStrategy(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    public PositionCoordinate getTopLeftPosition() {
        int rowPosition;
        PositionCoordinate lastSelectedCellPosition = this.selectionLayer.getLastSelectedCellPosition();
        if (lastSelectedCellPosition == null) {
            return null;
        }
        int columnPosition = this.viewportLayer.getOriginColumnPosition();
        if (columnPosition >= lastSelectedCellPosition.columnPosition) {
            columnPosition = lastSelectedCellPosition.columnPosition - 1;
        }
        if ((rowPosition = this.viewportLayer.getOriginRowPosition()) >= lastSelectedCellPosition.rowPosition) {
            rowPosition = lastSelectedCellPosition.rowPosition - 1;
        }
        return new PositionCoordinate(this.freezeLayer, columnPosition, rowPosition);
    }

    public PositionCoordinate getBottomRightPosition() {
        PositionCoordinate selectionAnchor = this.selectionLayer.getSelectionAnchor();
        if (selectionAnchor == null) {
            return null;
        }
        return new PositionCoordinate(this.freezeLayer, selectionAnchor.columnPosition - 1, selectionAnchor.rowPosition - 1);
    }
}

