/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnCategories.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.columnCategories.ColumnCategoriesModel;
import org.eclipse.nebula.widgets.nattable.columnCategories.IColumnCategoriesDialogListener;
import org.eclipse.nebula.widgets.nattable.columnCategories.Node;
import org.eclipse.nebula.widgets.nattable.columnCategories.gui.AvailableColumnCategoriesProvider;
import org.eclipse.nebula.widgets.nattable.columnCategories.gui.ColumnCategoriesLabelProvider;
import org.eclipse.nebula.widgets.nattable.columnCategories.gui.VisibleColumnsProvider;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnChooserUtils;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.columnChooser.gui.AbstractColumnChooserDialog;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnCategoriesDialog
extends AbstractColumnChooserDialog {
    private final ColumnCategoriesModel model;
    private List<ColumnEntry> hiddenColumnEntries;
    private List<ColumnEntry> visibleColumnsEntries;
    private TreeViewer treeViewer;
    private ListViewer listViewer;
    private ISelection lastListSelection;

    public ColumnCategoriesDialog(Shell shell, ColumnCategoriesModel model, List<ColumnEntry> hiddenColumnEntries, List<ColumnEntry> visibleColumnsEntries) {
        super(shell);
        this.model = model;
        this.hiddenColumnEntries = hiddenColumnEntries;
        this.visibleColumnsEntries = visibleColumnsEntries;
        this.setShellStyle(67696);
    }

    @Override
    public void populateDialogArea(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        parent.setLayout((Layout)new GridLayout(4, false));
        this.createLabels(parent, Messages.getString("ColumnChooser.availableColumns"), Messages.getString("ColumnChooser.selectedColumns"));
        GridData gridData = GridDataFactory.fillDefaults().grab(true, true).create();
        this.treeViewer = new TreeViewer(parent);
        this.populateAvailableTree();
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        this.createAddButton(buttonComposite);
        this.createRemoveButton(buttonComposite);
        this.addListenersToTreeViewer();
        this.listViewer = new ListViewer(parent, 2818);
        this.populateSelectedList();
        this.addListenersToListViewer();
        Composite upDownbuttonComposite = new Composite(parent, 0);
        upDownbuttonComposite.setLayout((Layout)new GridLayout(1, true));
        this.createUpButton(upDownbuttonComposite);
        this.createDownButton(upDownbuttonComposite);
    }

    private void populateSelectedList() {
        VisibleColumnsProvider listProvider = new VisibleColumnsProvider(this.visibleColumnsEntries);
        this.listViewer.setContentProvider((IContentProvider)listProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)listProvider);
        this.listViewer.setInput((Object)listProvider);
        this.listViewer.setContentProvider((IContentProvider)listProvider);
        this.listViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
    }

    private void addListenersToTreeViewer() {
        this.treeViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ColumnCategoriesDialog.this.addSelected();
            }
        });
    }

    private void addListenersToListViewer() {
        this.listViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ColumnCategoriesDialog.this.removeSelected();
            }
        });
        this.listViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean controlMask;
                boolean bl = controlMask = (e.stateMask & 0x40000) == 262144;
                if (controlMask && e.keyCode == 0x1000001) {
                    ColumnCategoriesDialog.this.moveSelectedUp();
                    e.doit = false;
                } else if (controlMask && e.keyCode == 0x1000002) {
                    ColumnCategoriesDialog.this.moveSelectedDown();
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ') {
                    ColumnCategoriesDialog.this.removeSelected();
                }
            }
        });
    }

    private void populateAvailableTree() {
        AvailableColumnCategoriesProvider provider = new AvailableColumnCategoriesProvider(this.model);
        provider.hideEntries(this.visibleColumnsEntries);
        this.treeViewer.setContentProvider((IContentProvider)provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ColumnCategoriesLabelProvider(this.hiddenColumnEntries));
        this.treeViewer.setInput((Object)provider);
    }

    private Button createDownButton(Composite upDownbuttonComposite) {
        Button downButton = new Button(upDownbuttonComposite, 8);
        downButton.setImage(GUIHelper.getImage("arrow_down"));
        downButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 0x1000000).create());
        downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnCategoriesDialog.this.moveSelectedDown();
            }
        });
        return downButton;
    }

    private Button createUpButton(Composite upDownbuttonComposite) {
        Button upButton = new Button(upDownbuttonComposite, 8);
        upButton.setImage(GUIHelper.getImage("arrow_up"));
        upButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 0x1000000).create());
        upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnCategoriesDialog.this.moveSelectedUp();
            }
        });
        return upButton;
    }

    private Button createRemoveButton(Composite buttonComposite) {
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setImage(GUIHelper.getImage("arrow_left"));
        removeButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 0x1000000).create());
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnCategoriesDialog.this.removeSelected();
            }
        });
        return removeButton;
    }

    private Button createAddButton(Composite buttonComposite) {
        Button addButton = new Button(buttonComposite, 8);
        addButton.setImage(GUIHelper.getImage("arrow_right"));
        addButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 0x1000000).create());
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnCategoriesDialog.this.addSelected();
            }
        });
        return addButton;
    }

    protected void removeSelected() {
        this.fireItemsRemoved(this.getColumnPositionsFromListViewer());
    }

    protected void addSelected() {
        this.fireItemsSelected(this.getColumnIndexesFromTreeNodes());
    }

    protected final void fireItemsSelected(List<Integer> addedColumnIndexes) {
        if (ObjectUtils.isNotEmpty(addedColumnIndexes)) {
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IColumnCategoriesDialogListener)listener).itemsSelected(addedColumnIndexes);
                ++n2;
            }
        }
    }

    protected final void fireItemsRemoved(List<Integer> removedColumnPositions) {
        if (ObjectUtils.isNotEmpty(removedColumnPositions)) {
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IColumnCategoriesDialogListener)listener).itemsRemoved(removedColumnPositions);
                ++n2;
            }
        }
    }

    protected final void fireItemsMoved(SelectionLayer.MoveDirectionEnum direction, List<Integer> toPositions) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IColumnCategoriesDialogListener)listener).itemsMoved(direction, toPositions);
            ++n2;
        }
    }

    protected void moveSelectedUp() {
        List<Integer> selectedPositions = ColumnChooserUtils.getColumnEntryPositions(this.getSelectedColumnEntriesFromListViewer());
        if (!selectedPositions.contains(0)) {
            this.fireItemsMoved(SelectionLayer.MoveDirectionEnum.UP, selectedPositions);
        }
    }

    protected void moveSelectedDown() {
        List<Integer> selectedPositions = ColumnChooserUtils.getColumnEntryPositions(this.getSelectedColumnEntriesFromListViewer());
        if (!selectedPositions.contains(this.visibleColumnsEntries.size())) {
            this.fireItemsMoved(SelectionLayer.MoveDirectionEnum.DOWN, selectedPositions);
        }
    }

    private List<Integer> getColumnPositionsFromListViewer() {
        return ColumnChooserUtils.getColumnEntryPositions(this.getSelectedColumnEntriesFromListViewer());
    }

    private List<ColumnEntry> getSelectedColumnEntriesFromListViewer() {
        this.lastListSelection = this.listViewer.getSelection();
        Object[] objects = ((StructuredSelection)this.lastListSelection).toArray();
        ArrayList<ColumnEntry> entries = new ArrayList<ColumnEntry>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            entries.add((ColumnEntry)object);
            ++n2;
        }
        return entries;
    }

    private List<Integer> getColumnIndexesFromTreeNodes() {
        Object[] nodes = ((TreeSelection)this.treeViewer.getSelection()).toArray();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Node node = (Node)object;
            if (Node.Type.COLUMN == node.getType()) {
                indexes.add(Integer.parseInt(node.getData()));
            }
            ++n2;
        }
        return indexes;
    }

    public void refresh(List<ColumnEntry> hiddenColumnEntries, List<ColumnEntry> visibleColumnsEntries) {
        this.hiddenColumnEntries = hiddenColumnEntries;
        this.visibleColumnsEntries = visibleColumnsEntries;
        this.populateAvailableTree();
        this.populateSelectedList();
        if (ObjectUtils.isNotNull(this.lastListSelection)) {
            this.listViewer.setSelection(this.lastListSelection);
        }
    }
}

