/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;

class LinesIterable
implements Iterable<Line> {
    private final LineSequence lineSequence;
    private final Predicate<Line> predicate;

    public LinesIterable(LineSequence lineSequence, Predicate<Line> predicate) {
        this.lineSequence = (LineSequence)Preconditions.checkNotNull((Object)lineSequence);
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    @Override
    public Iterator<Line> iterator() {
        return new LinesIterator();
    }

    class LinesIterator
    implements Iterator<Line> {
        LinesIterator() {
        }

        @Override
        public boolean hasNext() {
            Line currentLine = LinesIterable.this.lineSequence.getCurrentLine();
            return currentLine != null && LinesIterable.this.predicate.apply((Object)currentLine);
        }

        @Override
        public Line next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Line line = LinesIterable.this.lineSequence.getCurrentLine();
            LinesIterable.this.lineSequence.advance();
            return line;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

