/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public class CollectionLiterals {
    @Pure
    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    @Pure
    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    @Pure
    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    @Pure
    public static <T> List<T> newImmutableList(T ... elements) {
        return ImmutableList.copyOf((Object[])elements);
    }

    @Pure
    public static <T> Set<T> newImmutableSet(T ... elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    @Pure
    public static <K, V> Map<K, V> newImmutableMap(Pair<? extends K, ? extends V> ... entries) {
        if (entries.length == 0) {
            return CollectionLiterals.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Pair<? extends K, ? extends V>[] pairArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<K, V> entry = pairArray[n2];
            builder.put(entry.getKey(), entry.getValue());
            ++n2;
        }
        return builder.build();
    }

    @Pure
    public static <T> ArrayList<T> newArrayList(T ... initial) {
        return Lists.newArrayList((Object[])initial);
    }

    @Pure
    public static <T> LinkedList<T> newLinkedList(T ... initial) {
        if (initial.length > 0) {
            return Lists.newLinkedList(Arrays.asList(initial));
        }
        return Lists.newLinkedList();
    }

    @Pure
    public static <T> HashSet<T> newHashSet(T ... initial) {
        return Sets.newHashSet((Object[])initial);
    }

    @Pure
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... initial) {
        if (initial.length > 0) {
            return Sets.newLinkedHashSet(Arrays.asList(initial));
        }
        return Sets.newLinkedHashSet();
    }

    @Pure
    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator, T ... initial) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        if (initial.length > 0) {
            result.addAll(Arrays.asList(initial));
        }
        return result;
    }

    @Pure
    public static <K, V> HashMap<K, V> newHashMap(Pair<? extends K, ? extends V> ... initial) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)initial.length);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    @Pure
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Pair<? extends K, ? extends V> ... initial) {
        LinkedHashMap result = new LinkedHashMap(initial.length);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    @Pure
    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator, Pair<? extends K, ? extends V> ... initial) {
        TreeMap result = Maps.newTreeMap(comparator);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    private static <K, V> void putAll(Map<K, V> result, Pair<? extends K, ? extends V> ... entries) {
        Pair<? extends K, ? extends V>[] pairArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<K, V> entry = pairArray[n2];
            if (result.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("duplicate key: " + entry.getKey());
            }
            result.put(entry.getKey(), entry.getValue());
            ++n2;
        }
    }
}

