/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import com.google.common.collect.MapDifference;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.builder.DerivedResourceCleanerJob;
import org.eclipse.xtext.builder.preferences.BuilderConfigurationBlock;
import org.eclipse.xtext.ui.preferences.PropertyAndPreferencePage;

public class BuilderPreferencePage
extends PropertyAndPreferencePage {
    @Inject
    private BuilderConfigurationBlock builderConfigurationBlock;
    private String languageName;
    private Provider<DerivedResourceCleanerJob> cleanerProvider;

    @Inject
    public void setCleanerProvider(Provider<DerivedResourceCleanerJob> cleanerProvider) {
        this.cleanerProvider = cleanerProvider;
    }

    @Inject
    public void setLanguageName(@Named(value="languageName") String languageName) {
        this.languageName = languageName;
    }

    public void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        this.builderConfigurationBlock.setProject(this.getProject());
        this.builderConfigurationBlock.setWorkbenchPreferenceContainer(container);
        this.builderConfigurationBlock.setStatusChangeListener(this.getNewStatusChangedListener());
        super.createControl(parent);
    }

    protected Control createPreferenceContent(Composite composite, IPreferencePageContainer preferencePageContainer) {
        return this.builderConfigurationBlock.createContents(composite);
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.builderConfigurationBlock.hasProjectSpecificOptions(project);
    }

    protected String getPreferencePageID() {
        return String.valueOf(this.languageName) + ".compiler.preferencePage";
    }

    protected String getPropertyPageID() {
        return String.valueOf(this.languageName) + ".compiler.propertyPage";
    }

    public void dispose() {
        if (this.builderConfigurationBlock != null) {
            this.builderConfigurationBlock.dispose();
        }
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.builderConfigurationBlock != null) {
            this.builderConfigurationBlock.useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.builderConfigurationBlock != null) {
            this.builderConfigurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        if (this.builderConfigurationBlock != null) {
            this.scheduleCleanerJobIfNecessary(this.getContainer());
            if (!this.builderConfigurationBlock.performOk()) {
                return false;
            }
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.builderConfigurationBlock != null) {
            this.scheduleCleanerJobIfNecessary(null);
            this.builderConfigurationBlock.performApply();
        }
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }

    private void scheduleCleanerJobIfNecessary(IPreferencePageContainer preferencePageContainer) {
        Map changes = this.builderConfigurationBlock.getPreferenceChanges();
        for (String key : changes.keySet()) {
            if (!key.matches("^outlet\\.\\w+\\.directory$")) continue;
            MapDifference.ValueDifference difference = (MapDifference.ValueDifference)changes.get(key);
            this.scheduleCleanerJob(preferencePageContainer, (String)difference.rightValue());
        }
    }

    private void scheduleCleanerJob(IPreferencePageContainer preferencePageContainer, String folderNameToClean) {
        DerivedResourceCleanerJob derivedResourceCleanerJob = (DerivedResourceCleanerJob)((Object)this.cleanerProvider.get());
        derivedResourceCleanerJob.setUser(true);
        derivedResourceCleanerJob.initialize(this.getProject(), folderNameToClean);
        if (preferencePageContainer != null) {
            IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
            container.registerUpdateJob((Job)derivedResourceCleanerJob);
        } else {
            derivedResourceCleanerJob.schedule();
        }
    }
}

