/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;
import org.eclipse.xtext.ui.LanguageSpecific;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.resource.IResourceUIServiceProvider;
import org.eclipse.xtext.ui.resource.IResourceUIServiceProviderExtension;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.ResourceServiceDescriptionLabelProvider;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.IResourceValidator;

public class DefaultResourceUIServiceProvider
implements IResourceServiceProviderExtension,
IResourceUIServiceProvider,
IResourceUIServiceProviderExtension {
    private IResourceServiceProvider delegate;
    @Inject
    private IJdtHelper jdtHelper;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    @ResourceServiceDescriptionLabelProvider
    private ILabelProvider descriptionLabelProvider;
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject(optional=true)
    @LanguageSpecific
    private IURIEditorOpener uriEditorOpener;

    @Inject
    public DefaultResourceUIServiceProvider(IResourceServiceProvider delegate) {
        this.delegate = delegate;
    }

    public IContainer.Manager getContainerManager() {
        return this.delegate.getContainerManager();
    }

    public IResourceDescription.Manager getResourceDescriptionManager() {
        return this.delegate.getResourceDescriptionManager();
    }

    public IResourceValidator getResourceValidator() {
        return this.delegate.getResourceValidator();
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.descriptionLabelProvider;
    }

    public void setDescriptionLabelProvider(ILabelProvider descriptionLabelProvider) {
        this.descriptionLabelProvider = descriptionLabelProvider;
    }

    public boolean canHandle(URI uri) {
        boolean result = this.delegate.canHandle(uri);
        return result;
    }

    @Override
    public boolean canHandle(URI uri, IStorage storage) {
        if (this.delegate.canHandle(uri)) {
            if (this.isJavaCoreAvailable()) {
                return !this.isJavaTargetFolder(storage);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBuild(URI uri, IStorage storage) {
        return this.canHandle(uri, storage);
    }

    protected boolean isJavaCoreAvailable() {
        return this.jdtHelper.isJavaCoreAvailable();
    }

    protected boolean isJavaTargetFolder(IStorage storage) {
        if (storage instanceof IResource) {
            return this.jdtHelper.isFromOutputPath((IResource)storage);
        }
        return false;
    }

    public IEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    @Override
    public IURIEditorOpener getURIEditorOpener() {
        return this.uriEditorOpener;
    }

    @Override
    @Deprecated
    public IReferenceUpdater getReferenceUpdater() {
        return this.get(IReferenceUpdater.class);
    }

    public <T> T get(Class<T> t) {
        return (T)this.delegate.get(t);
    }

    public boolean isReadOnly(URI uri) {
        if (this.delegate instanceof IResourceServiceProviderExtension && ((IResourceServiceProviderExtension)this.delegate).isReadOnly(uri)) {
            return true;
        }
        Iterable<Pair<IStorage, IProject>> storages = this.storage2UriMapper.getStorages(uri);
        Iterator<Pair<IStorage, IProject>> iterator = storages.iterator();
        if (iterator.hasNext()) {
            Pair<IStorage, IProject> pair = iterator.next();
            IStorage storage = (IStorage)pair.getFirst();
            if (storage instanceof IFile) {
                return storage.isReadOnly();
            }
            return true;
        }
        return false;
    }
}

