/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.util.Strings;

public class JDTAwareEclipseResourceFileSystemAccess2
extends EclipseResourceFileSystemAccess2 {
    @Override
    @Deprecated
    protected void createFolder(IFolder folder) throws CoreException {
        super.createFolder(folder);
    }

    @Override
    protected void createContainer(IContainer container) throws CoreException {
        super.createContainer(container);
        this.addToSourceFolders(container);
    }

    protected void addToSourceFolders(IContainer container) throws JavaModelException {
        IJavaProject jp = JavaCore.create((IProject)container.getProject());
        if (jp.exists() && !jp.isOnClasspath((IResource)container)) {
            IClasspathEntry srcFolderClasspathEntry = JavaCore.newSourceEntry((IPath)container.getFullPath());
            IClasspathEntry[] classPath = jp.getRawClasspath();
            IClasspathEntry[] newClassPath = new IClasspathEntry[classPath.length + 1];
            System.arraycopy(classPath, 0, newClassPath, 1, classPath.length);
            newClassPath[0] = srcFolderClasspathEntry;
            jp.setRawClasspath(newClassPath, this.getMonitor());
        }
    }

    @Override
    public void flushSourceTraces(String generatorName) throws CoreException {
        Multimap<URI, IPath> sourceTraces = this.getSourceTraces();
        if (sourceTraces != null) {
            Set keys = sourceTraces.keySet();
            String source = this.getCurrentSource();
            IProject container = Strings.isEmpty((String)source) ? this.getProject() : this.getProject().getFolder(source);
            for (URI uri : keys) {
                if (uri == null || source == null) continue;
                Collection paths = sourceTraces.get((Object)uri);
                IFile sourceFile = container.getFile((IPath)new Path(uri.toFileString()));
                if (!sourceFile.exists()) continue;
                IPath[] tracePathArray = paths.toArray(new IPath[paths.size()]);
                this.getTraceMarkers().installMarker(sourceFile, generatorName, tracePathArray);
            }
        }
        this.resetSourceTraces();
    }
}

