/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public class StringExtensions {
    @Pure
    @Inline(value="($1 + $2)", constantExpression=true)
    public static String operator_plus(String a, Object b) {
        return a + String.valueOf(b);
    }

    @Pure
    @Inline(value="($1 + $2)", constantExpression=true)
    public static String operator_plus(String a, String b) {
        return a + b;
    }

    @Pure
    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    @Pure
    public static String toFirstUpper(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    @Pure
    public static String toFirstLower(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }
}

