/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ParallelFileSystemAccess
implements IFileSystemAccess2 {
    private final IFileSystemAccess2 delegate;
    private final IResourceDescription.Delta delta;
    private final FileSystemAccessQueue fileSystemAccessQueue;
    private final EclipseResourceFileSystemAccess2.IFileCallback fileCallback;
    private final String sourceFolder;

    public ParallelFileSystemAccess(IFileSystemAccess2 delegate, IResourceDescription.Delta delta, FileSystemAccessQueue fileSystemAccessQueue, String sourceFolder, EclipseResourceFileSystemAccess2.IFileCallback fileCallback) {
        this.delegate = delegate;
        this.delta = delta;
        this.fileSystemAccessQueue = fileSystemAccessQueue;
        this.sourceFolder = sourceFolder;
        this.fileCallback = fileCallback;
    }

    protected void sendAsync(Procedures.Procedure1<? super IFileSystemAccess2> procedure) {
        Runnable runnable = () -> {
            if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
                ((EclipseResourceFileSystemAccess2)this.delegate).setPostProcessor(this.fileCallback);
            }
            if (this.sourceFolder != null && this.delegate instanceof AbstractFileSystemAccess) {
                ((AbstractFileSystemAccess)this.delegate).setCurrentSource(this.sourceFolder);
            }
            procedure.apply((Object)this.delegate);
        };
        this.fileSystemAccessQueue.sendAsync(this.delta.getUri(), runnable);
    }

    public void deleteFile(String fileName) {
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)((Procedures.Procedure1)fsa -> fsa.deleteFile(fileName)));
    }

    public void generateFile(String fileName, CharSequence contents) {
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)((Procedures.Procedure1)fsa -> fsa.generateFile(fileName, contents)));
    }

    public void generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)((Procedures.Procedure1)fsa -> fsa.generateFile(fileName, outputConfigurationName, contents)));
    }

    public void deleteFile(String fileName, String outputConfigurationName) {
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)((Procedures.Procedure1)fsa -> fsa.deleteFile(fileName, outputConfigurationName)));
    }

    public URI getURI(String path, String outputConfiguration) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, outputConfiguration, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.getURI(path, outputConfiguration);
    }

    public URI getURI(String path) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.getURI(path);
    }

    public void generateFile(String fileName, String outputCfgName, InputStream content) throws RuntimeIOException {
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)((Procedures.Procedure1)fsa -> fsa.generateFile(fileName, outputCfgName, content)));
    }

    public void generateFile(String fileName, InputStream content) throws RuntimeIOException {
        this.sendAsync((Procedures.Procedure1<? super IFileSystemAccess2>)((Procedures.Procedure1)fsa -> fsa.generateFile(fileName, content)));
    }

    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, outputCfgName, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.readBinaryFile(fileName, outputCfgName);
    }

    public InputStream readBinaryFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.readBinaryFile(fileName);
    }

    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, outputCfgName, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.readTextFile(fileName, outputCfgName);
    }

    public CharSequence readTextFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.readTextFile(fileName);
    }

    public boolean isFile(String path, String outputConfigurationName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).isFile(path, outputConfigurationName, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.isFile(path, outputConfigurationName);
    }

    public boolean isFile(String path) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            return ((EclipseResourceFileSystemAccess2)this.delegate).isFile(path, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.delegate.isFile(path);
    }
}

