/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.xtext.util.Strings;

public class XtendTypeCreatorUtil {
    public static String createPackageDeclaration(String typeName, IPackageFragment packageFragment, String lineSeparator) {
        StringBuffer sb = new StringBuffer();
        if (packageFragment.getElementName() != null && !packageFragment.getElementName().equals("")) {
            sb.append("package ");
            sb.append(packageFragment.getElementName());
        }
        return sb.toString();
    }

    public static String createPackageDeclaration(String typeName, IPackageFragment packageFragment, String superClass, List superInterfaces, String lineSeparator) {
        int size;
        StringBuffer sb = new StringBuffer();
        if (packageFragment.getElementName() != null && !packageFragment.getElementName().equals("")) {
            sb.append("package ");
            sb.append(packageFragment.getElementName());
        }
        if ((size = superInterfaces.size()) > 0 || !superClass.equals("java.lang.Object")) {
            sb.append(lineSeparator);
            sb.append(lineSeparator);
        }
        if (!Strings.isEmpty((String)superClass) && !superClass.equals("java.lang.Object")) {
            XtendTypeCreatorUtil.addImport(sb, superClass, size != 0 ? lineSeparator : null);
        }
        int index = 0;
        while (index < size) {
            Object superInterface = superInterfaces.get(index);
            XtendTypeCreatorUtil.addImport(sb, superInterface, index + 1 != size ? lineSeparator : null);
            ++index;
        }
        return sb.toString();
    }

    public static String createPackageDeclaration(String typeName, IPackageFragment packageFragment, List superInterfaces, String lineSeparator) {
        int size;
        StringBuffer sb = new StringBuffer();
        if (packageFragment.getElementName() != null && !packageFragment.getElementName().equals("")) {
            sb.append("package ");
            sb.append(packageFragment.getElementName());
        }
        if ((size = superInterfaces.size()) > 0) {
            sb.append(lineSeparator);
            sb.append(lineSeparator);
        }
        int index = 0;
        while (index < size) {
            Object superInterface = superInterfaces.get(index);
            XtendTypeCreatorUtil.addImport(sb, superInterface, index + 1 != size ? lineSeparator : null);
            ++index;
        }
        return sb.toString();
    }

    public static String createClassContent(String typeName, String superClass, List superInterfaces, String indentation, String lineSeparator, boolean createMain) {
        Iterator i;
        StringBuffer sb = new StringBuffer();
        sb.append("class ");
        sb.append(typeName);
        if (!Strings.isEmpty((String)superClass) && !superClass.equals("java.lang.Object")) {
            sb.append(" extends ");
            sb.append(XtendTypeCreatorUtil.stripPackage(superClass));
        }
        if ((i = superInterfaces.iterator()).hasNext()) {
            sb.append(" implements ");
            sb.append(XtendTypeCreatorUtil.stripPackage(i.next()));
            while (i.hasNext()) {
                sb.append(", ");
                sb.append(XtendTypeCreatorUtil.stripPackage(i.next()));
            }
        }
        sb.append(" {");
        sb.append(lineSeparator);
        sb.append(indentation);
        if (createMain) {
            sb.append("def static void main(String[] args) {");
            sb.append(lineSeparator);
            sb.append(indentation);
            sb.append(indentation);
            sb.append(lineSeparator);
            sb.append(indentation);
            sb.append("}");
        }
        sb.append(lineSeparator);
        sb.append("}");
        return sb.toString();
    }

    public static String createInterfaceContent(String typeName, List superInterfaces, String indentation, String lineSeparator) {
        StringBuffer sb = new StringBuffer();
        sb.append("interface ");
        sb.append(typeName);
        Iterator i = superInterfaces.iterator();
        if (i.hasNext()) {
            sb.append(" extends ");
            sb.append(XtendTypeCreatorUtil.stripPackage(i.next()));
            while (i.hasNext()) {
                sb.append(", ");
                sb.append(XtendTypeCreatorUtil.stripPackage(i.next()));
            }
        }
        sb.append(" {");
        sb.append(lineSeparator);
        sb.append(indentation);
        sb.append(lineSeparator);
        sb.append("}");
        return sb.toString();
    }

    public static String createEnumContent(String typeName, String indentation, String lineSeparator) {
        StringBuffer sb = new StringBuffer();
        sb.append("enum ");
        sb.append(typeName);
        sb.append(" {");
        sb.append(lineSeparator);
        sb.append(indentation);
        sb.append(lineSeparator);
        sb.append("}");
        return sb.toString();
    }

    public static String createAnnotationContent(String typeName, String indentation, String lineSeparator) {
        StringBuffer sb = new StringBuffer();
        sb.append("annotation ");
        sb.append(typeName);
        sb.append(" {");
        sb.append(lineSeparator);
        sb.append(indentation);
        sb.append(lineSeparator);
        sb.append("}");
        return sb.toString();
    }

    private static Object stripPackage(Object superType) {
        return superType.toString().replaceAll("^(\\w+\\.)*", "");
    }

    private static void addImport(StringBuffer sb, Object object, String lineSeparator) {
        sb.append("import ");
        sb.append(XtendTypeCreatorUtil.removeGenerics(object));
        if (lineSeparator != null) {
            sb.append(lineSeparator);
        }
    }

    private static String removeGenerics(Object object) {
        String ret = object.toString().replaceAll("<.*>$", "");
        return ret;
    }
}

