/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xtext.ui.util.IProjectFactoryContributor;
import org.eclipse.xtext.ui.util.JREContainerProvider;
import org.eclipse.xtext.ui.util.JavaProjectFactory;
import org.eclipse.xtext.ui.util.PluginProjectFactory;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.util.JUnitVersion;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;
import org.eclipse.xtext.xtext.ui.wizard.project.XtextProjectInfo;
import org.eclipse.xtext.xtext.wizard.AbstractFile;
import org.eclipse.xtext.xtext.wizard.BinaryFile;
import org.eclipse.xtext.xtext.wizard.ParentProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectLayout;
import org.eclipse.xtext.xtext.wizard.SourceFolderDescriptor;
import org.eclipse.xtext.xtext.wizard.TestProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.TestedProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.TextFile;

public class XtextProjectCreator
extends WorkspaceModifyOperation
implements IProjectCreator {
    private static final Logger LOG = Logger.getLogger(XtextProjectCreator.class);
    @Inject
    private Provider<PluginProjectFactory> pluginProjectProvider;
    @Inject
    private Provider<JavaProjectFactory> javaProjectProvider;
    @Inject
    private Provider<ProjectFactory> plainProjectProvider;
    private XtextProjectInfo projectInfo;
    Map<ProjectDescriptor, IProject> createdProjects = Maps.newHashMap();
    private IFile result;

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getCreateModelProjectMessage(), (int)this.getMonitorTicks());
        for (ProjectDescriptor descriptor : this.projectInfo.getEnabledProjects()) {
            IProject project = this.createProject(descriptor, SubMonitor.convert((IProgressMonitor)subMonitor, (int)1));
            this.createdProjects.put(descriptor, project);
        }
        IProject runtimeProject = this.createdProjects.get(this.projectInfo.getRuntimeProject());
        IFile dslGrammarFile = runtimeProject.getFile(this.getPath((AbstractFile)this.projectInfo.getRuntimeProject().getGrammarFile()));
        BasicNewResourceWizard.selectAndReveal((IResource)dslGrammarFile, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        this.result = dslGrammarFile;
    }

    private IProject createProject(ProjectDescriptor descriptor, SubMonitor monitor) {
        if (this.isPluginProject(descriptor)) {
            return this.createPluginProject(descriptor, monitor);
        }
        if (this.isFeatureProject(descriptor)) {
            return this.createFeatureProject(descriptor, monitor);
        }
        if (this.isJavaProject(descriptor)) {
            return this.createJavaProject(descriptor, monitor);
        }
        return this.createPlainProject(descriptor, monitor);
    }

    private IProject createPluginProject(ProjectDescriptor descriptor, SubMonitor monitor) {
        PluginProjectFactory factory = (PluginProjectFactory)this.pluginProjectProvider.get();
        this.configureJavaProject(descriptor, (JavaProjectFactory)factory);
        factory.addProjectNatures(new String[]{"org.eclipse.pde.PluginNature"});
        factory.addBuilderIds(new String[]{"org.eclipse.pde.ManifestBuilder", "org.eclipse.pde.SchemaBuilder"});
        factory.addDevelopmentTimeBundles((List)Lists.newArrayList((Iterable)descriptor.getDevelopmentBundles()));
        factory.addImportedPackages((List)Lists.newArrayList((Iterable)descriptor.getImportedPackages()));
        factory.addRequiredBundles((List)Lists.newArrayList((Iterable)descriptor.getRequiredBundles()));
        factory.setBreeToUse(descriptor.getBree());
        return factory.createProject((IProgressMonitor)monitor, null);
    }

    private IProject createJavaProject(ProjectDescriptor descriptor, SubMonitor monitor) {
        JavaProjectFactory factory = (JavaProjectFactory)this.javaProjectProvider.get();
        this.configureJavaProject(descriptor, factory);
        return factory.createProject((IProgressMonitor)monitor, null);
    }

    private void configureJavaProject(ProjectDescriptor descriptor, JavaProjectFactory factory) {
        this.configurePlainProject(descriptor, (ProjectFactory)factory);
        factory.addProjectNatures(new String[]{"org.eclipse.xtext.ui.shared.xtextNature"});
        factory.addBuilderIds(new String[]{"org.eclipse.xtext.ui.shared.xtextBuilder"});
        factory.addProjectNatures(new String[]{"org.eclipse.jdt.core.javanature"});
        factory.addBuilderIds(new String[]{"org.eclipse.jdt.core.javabuilder"});
        for (SourceFolderDescriptor sourceFolder : descriptor.getSourceFolders()) {
            String output = sourceFolder.isTest() ? (this.needsM2eIntegration(descriptor) ? "target/test-classes" : "test-bin") : null;
            factory.addSourceFolder(sourceFolder.getPath(), output, sourceFolder.isTest());
        }
        factory.setJreContainerEntry(JREContainerProvider.getJREContainerEntry((String)descriptor.getBree()));
        if (this.needsM2eIntegration(descriptor)) {
            factory.setDefaultOutput("target/classes");
            if (!descriptor.isEclipsePluginProject()) {
                factory.addClasspathEntries(new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"))});
            }
        }
        if (this.needsBuildshipIntegration(descriptor) && !descriptor.isEclipsePluginProject()) {
            factory.addClasspathEntries(new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path("org.eclipse.buildship.core.gradleclasspathcontainer"))});
        }
        if (this.requiresJUnitLibContainer(descriptor)) {
            JUnitVersion junitVersion = descriptor.getConfig().getJunitVersion();
            factory.addClasspathEntries(new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append(Integer.toString(junitVersion.getVersion())), (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"test", (String)"true")}, (boolean)false)});
        }
    }

    private boolean requiresJUnitLibContainer(ProjectDescriptor descriptor) {
        TestedProjectDescriptor tpd;
        if (descriptor instanceof TestProjectDescriptor) {
            return true;
        }
        return descriptor instanceof TestedProjectDescriptor && (tpd = (TestedProjectDescriptor)descriptor).getTestProject().isInlined();
    }

    private IProject createFeatureProject(ProjectDescriptor descriptor, SubMonitor monitor) {
        ProjectFactory factory = (ProjectFactory)this.plainProjectProvider.get();
        this.configurePlainProject(descriptor, factory);
        factory.addProjectNatures(new String[]{"org.eclipse.pde.FeatureNature"});
        factory.addBuilderIds(new String[]{"org.eclipse.pde.FeatureBuilder"});
        return factory.createProject((IProgressMonitor)monitor, null);
    }

    private IProject createPlainProject(ProjectDescriptor descriptor, SubMonitor monitor) {
        ProjectFactory factory = (ProjectFactory)this.plainProjectProvider.get();
        this.configurePlainProject(descriptor, factory);
        return factory.createProject((IProgressMonitor)monitor, null);
    }

    private void configurePlainProject(ProjectDescriptor descriptor, ProjectFactory factory) {
        factory.setProjectName(descriptor.getName());
        factory.setLocation((IPath)new Path(descriptor.getLocation()));
        factory.setProjectDefaultCharset(this.projectInfo.getEncoding().toString());
        factory.addWorkingSets((List)Lists.newArrayList(this.projectInfo.getWorkingSets()));
        factory.addContributor((IProjectFactoryContributor)new DescriptorBasedContributor(descriptor));
        if (this.needsM2eIntegration(descriptor)) {
            factory.addProjectNatures(new String[]{"org.eclipse.m2e.core.maven2Nature"});
            factory.addBuilderIds(new String[]{"org.eclipse.m2e.core.maven2Builder"});
        }
        if (this.needsBuildshipIntegration(descriptor)) {
            factory.addProjectNatures(new String[]{"org.eclipse.buildship.core.gradleprojectnature"});
            factory.addBuilderIds(new String[]{"org.eclipse.buildship.core.gradleprojectbuilder"});
            factory.addEarlyContributor((IProjectFactoryContributor)new GradleContributor(descriptor));
        }
    }

    private boolean isPluginProject(ProjectDescriptor descriptor) {
        return descriptor.isEclipsePluginProject();
    }

    private boolean isFeatureProject(ProjectDescriptor descriptor) {
        return descriptor.isEclipseFeatureProject();
    }

    private boolean isJavaProject(ProjectDescriptor descriptor) {
        return !descriptor.getSourceFolders().isEmpty();
    }

    private boolean needsM2eIntegration(ProjectDescriptor descriptor) {
        return descriptor.isPartOfMavenBuild() && descriptor.getConfig().needsMavenBuild();
    }

    private boolean needsBuildshipIntegration(ProjectDescriptor descriptor) {
        return descriptor.isPartOfGradleBuild() && descriptor.getConfig().needsGradleBuild();
    }

    private int getMonitorTicks() {
        return this.projectInfo.getEnabledProjects().size();
    }

    private String getCreateModelProjectMessage() {
        return String.valueOf(Messages.XtextProjectCreator_CreatingProjectsMessage2) + this.projectInfo.getProjectName();
    }

    public void setProjectInfo(IProjectInfo projectInfo) {
        this.projectInfo = (XtextProjectInfo)projectInfo;
    }

    public IFile getResult() {
        return this.result;
    }

    private String getPath(AbstractFile file) {
        return String.valueOf(file.getProject().sourceFolder(file.getOutlet())) + "/" + file.getRelativePath();
    }

    private class DescriptorBasedContributor
    implements IProjectFactoryContributor {
        private ProjectDescriptor descriptor;

        public DescriptorBasedContributor(ProjectDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public void contributeFiles(IProject project, IProjectFactoryContributor.IFileCreator fileWriter) {
            for (AbstractFile file : this.descriptor.getFiles()) {
                if (this.isFiltered(file)) continue;
                String path = XtextProjectCreator.this.getPath(file);
                IFile created = null;
                if (file instanceof TextFile) {
                    created = fileWriter.writeToFile((CharSequence)((TextFile)file).getContent(), path);
                } else if (file instanceof BinaryFile) {
                    created = this.createBinaryFile(fileWriter, path, ((BinaryFile)file).getContent());
                }
                if (created == null || !file.isExecutable()) continue;
                this.addExecutableFlag(created);
            }
        }

        private void addExecutableFlag(IFile file) {
            ResourceAttributes attributes = file.getResourceAttributes();
            if (attributes != null) {
                attributes.setExecutable(true);
                try {
                    file.setResourceAttributes(attributes);
                }
                catch (CoreException e) {
                    LOG.warn((Object)("Failed to set executable flag for " + file.getFullPath().toOSString()), (Throwable)e);
                }
            }
        }

        private IFile createBinaryFile(IProjectFactoryContributor.IFileCreator fileWriter, String path, URL url) {
            IFile created;
            block12: {
                created = fileWriter.writeToFile((CharSequence)"", path);
                InputStream stream = null;
                try {
                    try {
                        stream = url.openStream();
                        created.setContents(stream, 1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to create binary file " + created.getFullPath().toOSString()), (Throwable)e);
                        if (stream == null) break block12;
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            LOG.warn((Object)("Failed to close stream for " + created.getFullPath().toOSString()), (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Failed to close stream for " + created.getFullPath().toOSString()), (Throwable)e);
                        }
                    }
                }
            }
            return created;
        }

        private boolean isFiltered(AbstractFile file) {
            if (XtextProjectCreator.this.isPluginProject(this.descriptor)) {
                return Sets.newHashSet((Object[])new String[]{"plugin.xml", "MANIFEST.MF"}).contains(file.getRelativePath());
            }
            return false;
        }
    }

    private static class GradleContributor
    implements IProjectFactoryContributor {
        private ProjectDescriptor descriptor;

        public GradleContributor(ProjectDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public void contributeFiles(IProject project, IProjectFactoryContributor.IFileCreator fileWriter) {
            fileWriter.writeToFile((CharSequence)("connection.arguments=\nconnection.gradle.distribution=GRADLE_DISTRIBUTION(WRAPPER)\nconnection.gradle.user.home=null\nconnection.java.home=null\nconnection.jvm.arguments=\nconnection.project.dir=" + this.getConnectionLogicalPath() + "\n" + "eclipse.preferences.version=1\n" + "project.path=\\" + this.getLogicalPath() + "\n"), ".settings/org.eclipse.buildship.core.prefs");
        }

        private String getLogicalPath() {
            if (this.descriptor instanceof ParentProjectDescriptor) {
                return ":";
            }
            return ":" + this.descriptor.getName();
        }

        private String getConnectionLogicalPath() {
            if (this.descriptor instanceof ParentProjectDescriptor) {
                return "";
            }
            if (this.descriptor.getConfig().getProjectLayout() == ProjectLayout.FLAT) {
                return "../" + this.descriptor.getConfig().getParentProject().getName();
            }
            return "..";
        }
    }
}

