/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.xtext.formatting2.regionaccess.HiddenRegionPartAssociation;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPartAssociator;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;

public class HiddenRegionPartAssociator
implements IHiddenRegionPartAssociator {
    @Override
    public void associate(IHiddenRegion region, BiConsumer<IHiddenRegionPart, HiddenRegionPartAssociation> handler) {
        List<IHiddenRegionPart> parts = region.getParts();
        if (!region.isMultiline()) {
            for (IHiddenRegionPart p : parts) {
                handler.accept(p, HiddenRegionPartAssociation.CONTAINER);
            }
        } else {
            int j;
            int i;
            if (region.getPreviousSemanticRegion() != null) {
                for (i = 0; i < parts.size(); ++i) {
                    IHiddenRegionPart part = parts.get(i);
                    if (part.isMultiline()) {
                        if (!part.getText().endsWith("\n")) break;
                        handler.accept(part, HiddenRegionPartAssociation.PREVIOUS);
                        ++i;
                        break;
                    }
                    handler.accept(part, HiddenRegionPartAssociation.PREVIOUS);
                }
            }
            if (region.getNextSemanticRegion() != null) {
                IHiddenRegionPart part;
                for (j = parts.size() - 1; !(j < i || (part = parts.get(j)) instanceof IWhitespace && part.getLineCount() > 2); --j) {
                    handler.accept(part, HiddenRegionPartAssociation.NEXT);
                }
            }
            for (int k = i; k <= j; ++k) {
                IHiddenRegionPart part = parts.get(k);
                handler.accept(part, HiddenRegionPartAssociation.CONTAINER);
            }
        }
    }
}

