/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.internal.EmfAdaptable;

@EmfAdaptable
public class ClassFileCache {
    private static final Object NULL = new Object();
    private final Map<QualifiedName, Object> cache = new ConcurrentHashMap<QualifiedName, Object>();

    public boolean containsKey(QualifiedName qualifiedName) {
        return this.cache.containsKey(qualifiedName);
    }

    public IBinaryType get(QualifiedName qualifiedName) {
        Object result = this.cache.get(qualifiedName);
        if (result == NULL) {
            return null;
        }
        return (IBinaryType)result;
    }

    public void put(QualifiedName qualifiedName, IBinaryType answer) {
        if (answer == null) {
            this.cache.put(qualifiedName, NULL);
        } else {
            this.cache.put(qualifiedName, answer);
        }
    }

    public IBinaryType computeIfAbsent(QualifiedName qualifiedName, Function<? super QualifiedName, ? extends IBinaryType> fun) {
        Function<QualifiedName, Object> _function = it -> {
            Object _elvis = null;
            IBinaryType _apply = (IBinaryType)fun.apply((QualifiedName)it);
            _elvis = _apply != null ? _apply : NULL;
            return _elvis;
        };
        Object result = this.cache.computeIfAbsent(qualifiedName, _function);
        if (result instanceof IBinaryType) {
            return (IBinaryType)result;
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    public static ClassFileCache findInEmfObject(Notifier emfObject) {
        for (Adapter adapter : emfObject.eAdapters()) {
            if (!(adapter instanceof ClassFileCacheAdapter)) continue;
            return ((ClassFileCacheAdapter)adapter).get();
        }
        return null;
    }

    public static ClassFileCache removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        int max = adapters.size();
        for (int i = 0; i < max; ++i) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (!(adapter instanceof ClassFileCacheAdapter)) continue;
            emfObject.eAdapters().remove(i);
            return ((ClassFileCacheAdapter)adapter).get();
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        ClassFileCache result = ClassFileCache.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for ClassFileCache");
        }
        ClassFileCacheAdapter adapter = new ClassFileCacheAdapter(this);
        emfObject.eAdapters().add((Object)adapter);
    }

    public static class ClassFileCacheAdapter
    extends AdapterImpl {
        private ClassFileCache element;

        public ClassFileCacheAdapter(ClassFileCache element) {
            this.element = element;
        }

        public ClassFileCache get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == ClassFileCache.class;
        }
    }
}

