/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SerializableEObjectDescription
implements IEObjectDescription,
Externalizable {
    private URI eObjectURI;
    private EClass eClass;
    private QualifiedName qualifiedName;
    private HashMap<String, String> userData;
    @Accessors(value={AccessorType.NONE})
    private transient EObject eObjectOrProxy;

    public void updateResourceURI(URI uri) {
        URI _appendFragment;
        String _fragment = this.eObjectURI.fragment();
        this.eObjectURI = _appendFragment = uri.appendFragment(_fragment);
    }

    @Override
    public EObject getEObjectOrProxy() {
        boolean _equals = Objects.equal((Object)this.eObjectOrProxy, null);
        if (_equals) {
            EObject proxy = EcoreUtil.create((EClass)this.eClass);
            ((InternalEObject)proxy).eSetProxyURI(this.eObjectURI);
            this.eObjectOrProxy = proxy;
        }
        return this.eObjectOrProxy;
    }

    @Override
    public QualifiedName getName() {
        return this.qualifiedName;
    }

    @Override
    public String getUserData(String key) {
        return this.userData.get(key);
    }

    @Override
    public String[] getUserDataKeys() {
        return (String[])Conversions.unwrapArray(this.userData.keySet(), String.class);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap _readCastedObject;
        QualifiedName _readQualifiedName;
        EClass _readEcoreElement;
        URI _readURI;
        this.eObjectURI = _readURI = SerializationExtensions.readURI(in);
        this.eClass = _readEcoreElement = (EClass)SerializationExtensions.readEcoreElement(in);
        this.qualifiedName = _readQualifiedName = SerializationExtensions.readQualifiedName(in);
        this.userData = _readCastedObject = (HashMap)SerializationExtensions.readCastedObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.eObjectURI);
        URI _uRI = EcoreUtil.getURI((EObject)this.eClass);
        SerializationExtensions.writeURI(out, _uRI);
        SerializationExtensions.writeQualifiedName(out, this.qualifiedName);
        out.writeObject(this.userData);
    }

    @Override
    @Pure
    public URI getEObjectURI() {
        return this.eObjectURI;
    }

    public void setEObjectURI(URI eObjectURI) {
        this.eObjectURI = eObjectURI;
    }

    @Override
    @Pure
    public EClass getEClass() {
        return this.eClass;
    }

    public void setEClass(EClass eClass) {
        this.eClass = eClass;
    }

    @Override
    @Pure
    public QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Pure
    public HashMap<String, String> getUserData() {
        return this.userData;
    }

    public void setUserData(HashMap<String, String> userData) {
        this.userData = userData;
    }
}

