/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.tasks.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.DialogField;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.IListAdapter;
import org.eclipse.xtext.ui.util.PixelConverter;
import org.eclipse.xtext.ui.util.SWTUtil;

public class ListDialogField
extends DialogField {
    protected TableViewer fTable;
    protected Control fTableControl;
    protected ILabelProvider fLabelProvider;
    protected ListViewerAdapter fListViewerAdapter;
    protected List fElements;
    protected ViewerComparator fViewerComparator;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private IListAdapter fListAdapter;
    private Object fParentElement;
    private ColumnsDescription fTableColumns;

    public ListDialogField(IListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
        this.fListAdapter = adapter;
        this.fLabelProvider = lprovider;
        this.fListViewerAdapter = new ListViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList(10);
        this.fButtonLabels = buttonLabels;
        if (this.fButtonLabels != null) {
            int nButtons = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[nButtons];
            int i = 0;
            while (i < nButtons) {
                this.fButtonsEnabled[i] = true;
                ++i;
            }
        }
        this.fTable = null;
        this.fTableControl = null;
        this.fButtonsControl = null;
        this.fTableColumns = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
    }

    public void setRemoveButtonIndex(int removeButtonIndex) {
        Assert.isTrue((removeButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = removeButtonIndex;
    }

    public void setUpButtonIndex(int upButtonIndex) {
        Assert.isTrue((upButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = upButtonIndex;
    }

    public void setDownButtonIndex(int downButtonIndex) {
        Assert.isTrue((downButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = downButtonIndex;
    }

    public void setViewerComparator(ViewerComparator viewerComparator) {
        this.fViewerComparator = viewerComparator;
    }

    public void setTableColumns(ColumnsDescription column) {
        this.fTableColumns = column;
    }

    private void buttonPressed(int index) {
        if (!this.managedButtonPressed(index) && this.fListAdapter != null) {
            this.fListAdapter.customButtonPressed(this, index);
        }
    }

    protected boolean managedButtonPressed(int index) {
        if (index == this.fRemoveButtonIndex) {
            this.remove();
        } else if (index == this.fUpButtonIndex) {
            this.up();
            if (!this.fButtonControls[index].isEnabled() && this.fDownButtonIndex != -1) {
                this.fButtonControls[this.fDownButtonIndex].setFocus();
            }
        } else if (index == this.fDownButtonIndex) {
            this.down();
            if (!this.fButtonControls[index].isEnabled() && this.fUpButtonIndex != -1) {
                this.fButtonControls[this.fUpButtonIndex].setFocus();
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        GridData gd = ListDialogField.gridDataForLabel(1);
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        Control list = this.getListControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        gd.heightHint = converter.convertHeightInCharsToPixels(6);
        list.setLayoutData((Object)gd);
        Composite buttons = this.getButtonBox(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 1;
        buttons.setLayoutData((Object)gd);
        return new Control[]{label, list, buttons};
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int minWidth) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = minWidth;
        }
    }

    public Control getListControl(Composite parent) {
        if (this.fTableControl == null) {
            this.assertCompositeNotNull(parent);
            if (this.fTableColumns == null) {
                this.fTable = this.createTableViewer(parent);
                Table tableControl = this.fTable.getTable();
                this.fTableControl = tableControl;
                tableControl.setLayout((Layout)new TableLayout());
            } else {
                TableLayoutComposite composite = new TableLayoutComposite(parent, 0);
                composite.setFont(parent.getFont());
                this.fTableControl = composite;
                this.fTable = this.createTableViewer(composite);
                Table tableControl = this.fTable.getTable();
                tableControl.setHeaderVisible(this.fTableColumns.headers != null);
                tableControl.setLinesVisible(this.fTableColumns.drawLines);
                ColumnLayoutData[] columns = this.fTableColumns.columns;
                int i = 0;
                while (i < columns.length) {
                    composite.addColumnData(columns[i]);
                    TableColumn column = new TableColumn(tableControl, 0);
                    if (this.fTableColumns.headers != null) {
                        column.setText(this.fTableColumns.headers[i]);
                    }
                    ++i;
                }
            }
            this.fTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    ListDialogField.this.handleKeyPressed(e);
                }
            });
            this.fTable.setContentProvider((IContentProvider)this.fListViewerAdapter);
            this.fTable.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTable.addSelectionChangedListener((ISelectionChangedListener)this.fListViewerAdapter);
            this.fTable.addDoubleClickListener((IDoubleClickListener)this.fListViewerAdapter);
            this.fTable.setInput(this.fParentElement);
            if (this.fViewerComparator != null) {
                this.fTable.setComparator(this.fViewerComparator);
            }
            this.fTableControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.selectElements(this.fSelectionWhenEnabled);
            }
        }
        return this.fTableControl;
    }

    public TableViewer getTableViewer() {
        return this.fTable;
    }

    protected int getListStyle() {
        int style = 2818;
        if (this.fTableColumns != null) {
            style |= 0x10000;
        }
        return style;
    }

    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, this.getListStyle());
        table.setFont(parent.getFont());
        return new TableViewer(table);
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setFont(parent.getFont());
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.verticalIndent = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    public Composite getButtonBox(Composite parent) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(parent);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ListDialogField.this.doButtonSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ListDialogField.this.doButtonSelected(e);
                }
            };
            Composite contents = new Composite(parent, 0);
            contents.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            contents.setLayout((Layout)layout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int i = 0;
                while (i < this.fButtonLabels.length) {
                    String currLabel = this.fButtonLabels[i];
                    if (currLabel != null) {
                        this.fButtonControls[i] = this.createButton(contents, currLabel, listener);
                        this.fButtonControls[i].setEnabled(this.isEnabled() && this.fButtonsEnabled[i]);
                    } else {
                        this.fButtonControls[i] = null;
                        this.createSeparator(contents);
                    }
                    ++i;
                }
            }
            this.fLastSeparator = this.createSeparator(contents);
            this.updateButtonState();
            this.fButtonsControl = contents;
        }
        return this.fButtonsControl;
    }

    private void doButtonSelected(SelectionEvent e) {
        if (this.fButtonControls != null) {
            int i = 0;
            while (i < this.fButtonControls.length) {
                if (e.widget == this.fButtonControls[i]) {
                    this.buttonPressed(i);
                    return;
                }
                ++i;
            }
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.fRemoveButtonIndex != -1 && this.isButtonEnabled(this.fTable.getSelection(), this.fRemoveButtonIndex)) {
            this.managedButtonPressed(this.fRemoveButtonIndex);
        }
    }

    @Override
    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null && this.isOkToUse(this.fTableControl) && this.fTableControl.isEnabled()) {
            ISelection sel = this.fTable.getSelection();
            int i = 0;
            while (i < this.fButtonControls.length) {
                Button button = this.fButtonControls[i];
                if (this.isOkToUse((Control)button)) {
                    button.setEnabled(this.isButtonEnabled(sel, i));
                }
                ++i;
            }
        }
    }

    protected boolean getManagedButtonState(ISelection sel, int index) {
        if (index == this.fRemoveButtonIndex) {
            return !sel.isEmpty();
        }
        if (index == this.fUpButtonIndex) {
            return !sel.isEmpty() && this.canMoveUp();
        }
        if (index == this.fDownButtonIndex) {
            return !sel.isEmpty() && this.canMoveDown();
        }
        return true;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        boolean enabled = this.isEnabled();
        if (this.isOkToUse(this.fTableControl)) {
            if (!enabled) {
                if (this.fSelectionWhenEnabled == null) {
                    this.fSelectionWhenEnabled = this.fTable.getSelection();
                    this.selectElements(null);
                }
            } else if (this.fSelectionWhenEnabled != null) {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTableControl.setEnabled(enabled);
        }
        this.updateButtonState();
    }

    public void enableButton(int index, boolean enable) {
        if (this.fButtonsEnabled != null && index < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[index] = enable;
            this.updateButtonState();
        }
    }

    private boolean isButtonEnabled(ISelection sel, int index) {
        boolean extraState = this.getManagedButtonState(sel, index);
        return this.isEnabled() && extraState && this.fButtonsEnabled[index];
    }

    public void setElements(Collection elements) {
        this.fElements = new ArrayList(elements);
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
        }
        this.dialogFieldChanged();
    }

    public List getElements() {
        return new ArrayList(this.fElements);
    }

    public Object getElement(int index) {
        return this.fElements.get(index);
    }

    public int getIndexOfElement(Object elem) {
        return this.fElements.indexOf(elem);
    }

    public void replaceElement(Object oldElement, Object newElement) throws IllegalArgumentException {
        int idx = this.fElements.indexOf(oldElement);
        if (idx != -1) {
            this.fElements.set(idx, newElement);
            if (this.isOkToUse(this.fTableControl)) {
                List selected = this.getSelectedElements();
                if (selected.remove(oldElement)) {
                    selected.add(newElement);
                }
                this.fTable.refresh();
                this.selectElements((ISelection)new StructuredSelection(selected));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void elementChanged(Object element) throws IllegalArgumentException {
        if (this.fElements.contains(element)) {
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.update(element, null);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public boolean addElement(Object element) {
        return this.addElement(element, this.fElements.size());
    }

    public boolean addElement(Object element, int index) {
        if (this.fElements.contains(element)) {
            return false;
        }
        this.fElements.add(index, element);
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
            this.fTable.setSelection((ISelection)new StructuredSelection(element));
        }
        this.dialogFieldChanged();
        return true;
    }

    public boolean addElements(List elements, int index) {
        int nElements = elements.size();
        if (nElements > 0 && index >= 0 && index <= this.fElements.size()) {
            ArrayList elementsToAdd = new ArrayList(nElements);
            int i = 0;
            while (i < nElements) {
                Object elem = elements.get(i);
                if (!this.fElements.contains(elem)) {
                    elementsToAdd.add(elem);
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty()) {
                this.fElements.addAll(index, elementsToAdd);
                if (this.isOkToUse(this.fTableControl)) {
                    if (index == this.fElements.size()) {
                        this.fTable.add(elementsToAdd.toArray());
                    } else {
                        i = elementsToAdd.size() - 1;
                        while (i >= 0) {
                            this.fTable.insert(elementsToAdd.get(i), index);
                            --i;
                        }
                    }
                    this.fTable.setSelection((ISelection)new StructuredSelection(elementsToAdd));
                }
                this.dialogFieldChanged();
                return true;
            }
        }
        return false;
    }

    public boolean addElements(List elements) {
        return this.addElements(elements, this.fElements.size());
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.refresh();
            }
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object element) throws IllegalArgumentException {
        if (this.fElements.remove(element)) {
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(element);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List elements) {
        if (elements.size() > 0) {
            this.fElements.removeAll(elements);
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(elements.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection selection) {
        this.fSelectionWhenEnabled = selection;
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.setSelection(selection, true);
        }
    }

    public void selectFirstElement() {
        Object element = null;
        if (this.fViewerComparator != null) {
            Object[] arr = this.fElements.toArray();
            this.fViewerComparator.sort((Viewer)this.fTable, arr);
            if (arr.length > 0) {
                element = arr[0];
            }
        } else if (this.fElements.size() > 0) {
            element = this.fElements.get(0);
        }
        if (element != null) {
            this.selectElements((ISelection)new StructuredSelection(element));
        }
    }

    public void editElement(Object element) {
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh(element);
            this.fTable.editElement(element, 0);
        }
    }

    public void postSetSelection(final ISelection selection) {
        if (this.isOkToUse(this.fTableControl)) {
            Display d = this.fTableControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ListDialogField.this.isOkToUse(ListDialogField.this.fTableControl)) {
                        ListDialogField.this.selectElements(selection);
                    }
                }
            });
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
        }
    }

    private List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    private void moveUp(List toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.setElements(this.moveUp(this.fElements, toMoveUp));
            this.fTable.reveal(toMoveUp.get(0));
        }
    }

    private void moveDown(List toMoveDown) {
        if (toMoveDown.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), toMoveDown)));
            this.fTable.reveal(toMoveDown.get(toMoveDown.size() - 1));
        }
    }

    private List reverse(List p) {
        ArrayList reverse = new ArrayList(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    public boolean canMoveUp() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] indc = this.fTable.getTable().getSelectionIndices();
            int i = 0;
            while (i < indc.length) {
                if (indc[i] != i) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean canMoveDown() {
        if (this.isOkToUse(this.fTableControl)) {
            int[] indc = this.fTable.getTable().getSelectionIndices();
            int k = this.fElements.size() - 1;
            int i = indc.length - 1;
            while (i >= 0) {
                if (indc[i] != k) {
                    return true;
                }
                --i;
                --k;
            }
        }
        return false;
    }

    public List getSelectedElements() {
        ISelection selection;
        ArrayList result = new ArrayList();
        if (this.isOkToUse(this.fTableControl) && (selection = this.fTable.getSelection()) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    protected void doListSelected(SelectionChangedEvent event) {
        this.updateButtonState();
        if (this.fListAdapter != null) {
            this.fListAdapter.selectionChanged(this);
        }
    }

    protected void doDoubleClick(DoubleClickEvent event) {
        if (this.fListAdapter != null) {
            this.fListAdapter.doubleClicked(this);
        }
    }

    @Deprecated(forRemoval=true)
    public void setViewerSorter(ViewerSorter sorter) {
        this.setViewerComparator((ViewerComparator)sorter);
    }

    public static class ColumnsDescription {
        private ColumnLayoutData[] columns;
        private String[] headers;
        private boolean drawLines;

        public ColumnsDescription(ColumnLayoutData[] columns, String[] headers, boolean drawLines) {
            this.columns = columns;
            this.headers = headers;
            this.drawLines = drawLines;
        }

        public ColumnsDescription(String[] headers, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(headers.length), headers, drawLines);
        }

        public ColumnsDescription(int nColumns, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(nColumns), null, drawLines);
        }

        private static ColumnLayoutData[] createColumnWeightData(int nColumns) {
            ColumnLayoutData[] data = new ColumnLayoutData[nColumns];
            int i = 0;
            while (i < nColumns) {
                data[i] = new ColumnWeightData(1);
                ++i;
            }
            return data;
        }
    }

    private class ListViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private ListViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return ListDialogField.this.fElements.toArray();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ListDialogField.this.doListSelected(event);
        }

        public void doubleClick(DoubleClickEvent event) {
            ListDialogField.this.doDoubleClick(event);
        }
    }

    static class TableLayoutComposite
    extends Composite {
        private static int COLUMN_TRIM;
        private List columns = new ArrayList();

        static {
            String platform = SWT.getPlatform();
            COLUMN_TRIM = "win32".equals(platform) ? 4 : ("carbon".equals(platform) ? 24 : 3);
        }

        public TableLayoutComposite(Composite parent, int style) {
            super(parent, style);
            this.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = this.getClientArea();
                    Table table = (Table)this.getChildren()[0];
                    Point preferredSize = this.computeTableSize(table);
                    int width = area.width - 2 * table.getBorderWidth();
                    if (preferredSize.y > area.height) {
                        Point vBarSize = table.getVerticalBar().getSize();
                        width -= vBarSize.x;
                    }
                    this.layoutTable(table, width, area, table.getSize().x < area.width);
                }
            });
        }

        public void addColumnData(ColumnLayoutData data) {
            this.columns.add(data);
        }

        private Point computeTableSize(Table table) {
            Point result = table.computeSize(-1, -1);
            int width = 0;
            int size = this.columns.size();
            int i = 0;
            while (i < size) {
                ColumnLayoutData layoutData = (ColumnLayoutData)this.columns.get(i);
                if (layoutData instanceof ColumnPixelData) {
                    col = (ColumnPixelData)layoutData;
                    width += col.width;
                    if (col.addTrim) {
                        width += COLUMN_TRIM;
                    }
                } else if (layoutData instanceof ColumnWeightData) {
                    col = (ColumnWeightData)layoutData;
                    width += col.minimumWidth;
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown column layout data");
                }
                ++i;
            }
            if (width > result.x) {
                result.x = width;
            }
            return result;
        }

        private void layoutTable(Table table, int width, Rectangle area, boolean increase) {
            if (width <= 1) {
                return;
            }
            TableColumn[] tableColumns = table.getColumns();
            int size = Math.min(this.columns.size(), tableColumns.length);
            int[] widths = new int[size];
            int fixedWidth = 0;
            int numberOfWeightColumns = 0;
            int totalWeight = 0;
            int i = 0;
            while (i < size) {
                ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i);
                if (col instanceof ColumnPixelData) {
                    ColumnPixelData cpd = (ColumnPixelData)col;
                    int pixels = cpd.width;
                    if (cpd.addTrim) {
                        pixels += COLUMN_TRIM;
                    }
                    widths[i] = pixels;
                    fixedWidth += pixels;
                } else if (col instanceof ColumnWeightData) {
                    ColumnWeightData cw = (ColumnWeightData)col;
                    ++numberOfWeightColumns;
                    int weight = cw.weight;
                    totalWeight += weight;
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown column layout data");
                }
                ++i;
            }
            if (numberOfWeightColumns > 0) {
                int rest = width - fixedWidth;
                int totalDistributed = 0;
                int i2 = 0;
                while (i2 < size) {
                    ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i2);
                    if (col instanceof ColumnWeightData) {
                        int pixels;
                        ColumnWeightData cw = (ColumnWeightData)col;
                        int weight = cw.weight;
                        int n = pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                        if (pixels < cw.minimumWidth) {
                            pixels = cw.minimumWidth;
                        }
                        totalDistributed += pixels;
                        widths[i2] = pixels;
                    }
                    ++i2;
                }
                int diff = rest - totalDistributed;
                int i3 = 0;
                while (diff > 0) {
                    ColumnLayoutData col;
                    if (i3 == size) {
                        i3 = 0;
                    }
                    if ((col = (ColumnLayoutData)this.columns.get(i3)) instanceof ColumnWeightData) {
                        int n = i3;
                        widths[n] = widths[n] + 1;
                        --diff;
                    }
                    ++i3;
                }
            }
            if (increase) {
                table.setSize(area.width, area.height);
            }
            i = 0;
            while (i < size) {
                tableColumns[i].setWidth(widths[i]);
                ++i;
            }
            if (!increase) {
                table.setSize(area.width, area.height);
            }
        }
    }
}

