/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.TextFileAccess;

@Accessors
public class PluginXmlAccess
extends TextFileAccess
implements IGuiceAwareGeneratorComponent {
    private static final Logger LOG = Logger.getLogger(PluginXmlAccess.class);
    @Inject
    private CodeConfig codeConfig;
    private final List<CharSequence> entries = CollectionLiterals.newArrayList();

    public PluginXmlAccess() {
        this.setPath("plugin.xml");
    }

    @Override
    public void setContent(StringConcatenationClient content) {
        throw new UnsupportedOperationException("cannot directly set contents on a plugin.xml. Use entries property instead");
    }

    @Override
    public CharSequence getContent() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"");
        String _elvis = null;
        String _encoding = this.codeConfig.getEncoding();
        _elvis = _encoding != null ? _encoding : "UTF-8";
        _builder.append(_elvis);
        _builder.append("\"?>");
        _builder.newLineIfNotEmpty();
        _builder.append("<?eclipse version=\"3.0\"?>");
        _builder.newLine();
        _builder.append("<plugin>");
        _builder.newLine();
        for (CharSequence entry : this.entries) {
            _builder.append("\t");
            _builder.append((Object)entry, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</plugin>");
        _builder.newLine();
        return _builder;
    }

    public boolean merge(PluginXmlAccess other) {
        String _path_1;
        boolean _notEquals;
        boolean _xblockexpression = false;
        String _path = this.getPath();
        boolean bl = _notEquals = !Objects.equal((Object)_path, (Object)(_path_1 = other.getPath()));
        if (_notEquals) {
            String _path_2 = this.getPath();
            String _plus = "Merging plugin.xml files with different paths: " + _path_2;
            String _plus_1 = String.valueOf(_plus) + ", ";
            String _path_3 = other.getPath();
            String _plus_2 = String.valueOf(_plus_1) + _path_3;
            LOG.warn((Object)_plus_2);
        }
        _xblockexpression = this.entries.addAll(other.entries);
        return _xblockexpression;
    }

    @Override
    public void writeTo(IFileSystemAccess2 fileSystemAccess) {
        boolean _not;
        boolean _isEmpty = this.entries.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            super.writeTo(fileSystemAccess);
        }
    }

    @Override
    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
    }

    @Pure
    public CodeConfig getCodeConfig() {
        return this.codeConfig;
    }

    public void setCodeConfig(CodeConfig codeConfig) {
        this.codeConfig = codeConfig;
    }

    @Pure
    public List<CharSequence> getEntries() {
        return this.entries;
    }
}

