/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hyperlinking;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XtendFileHyperlink
implements IHyperlink {
    private String fileName;
    private int lineNumber;
    private IWorkbench workbench;
    private TextConsole console;

    public XtendFileHyperlink(String fileName, IWorkbench workbench, TextConsole console) {
        int indexOfColon = fileName.indexOf(":");
        if (indexOfColon != -1) {
            this.fileName = fileName.substring(0, indexOfColon);
            this.lineNumber = Integer.valueOf(fileName.substring(indexOfColon + 1));
        } else {
            this.fileName = fileName;
        }
        this.workbench = workbench;
        this.console = console;
    }

    public void linkActivated() {
        try {
            try {
                ILaunch _launch = this.getLaunch();
                ISourceLocator _sourceLocator = null;
                if (_launch != null) {
                    _sourceLocator = _launch.getSourceLocator();
                }
                ISourceLocator l = _sourceLocator;
                boolean _matched = false;
                if (l instanceof AbstractSourceLookupDirector) {
                    _matched = true;
                    Object result = ((AbstractSourceLookupDirector)l).getSourceElement((Object)this.fileName);
                    boolean _matched_1 = false;
                    if (result instanceof IFile) {
                        _matched_1 = true;
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)result));
                        boolean _matched_2 = false;
                        if (editor instanceof XtextEditor) {
                            _matched_2 = true;
                            IRegion region = ((XtextEditor)editor).getDocument().getLineInformation(this.lineNumber - 1);
                            ((XtextEditor)editor).selectAndReveal(region.getOffset(), region.getLength());
                        }
                    }
                }
            }
            catch (Throwable _t) {
                if (!(_t instanceof NumberFormatException)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    private ILaunch getLaunch() {
        Object _attribute = this.console.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
        IProcess process = (IProcess)_attribute;
        if (process != null) {
            return process.getLaunch();
        }
        return null;
    }
}

