/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.PrimitiveMirror;
import org.eclipse.xtext.common.types.access.impl.PrimitiveTypeFactory;

public abstract class AbstractJvmTypeProvider
implements IJvmTypeProvider,
Resource.Factory {
    private final ResourceSet resourceSet;
    private final PrimitiveTypeFactory primitiveTypeFactory;
    private final IndexedJvmTypeAccess indexedJvmTypeAccess;

    protected AbstractJvmTypeProvider(ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null");
        }
        this.indexedJvmTypeAccess = indexedJvmTypeAccess;
        this.resourceSet = resourceSet;
        this.registerProtocol(resourceSet);
        this.primitiveTypeFactory = new PrimitiveTypeFactory();
    }

    protected void registerProtocol(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("java", this);
    }

    public abstract JvmType findTypeByName(String var1);

    public TypeResource createResource(URI uri) {
        TypeResource result = this.doCreateResource(uri);
        IMirror createMirror = this.createMirror(uri);
        if (createMirror != null) {
            result.setMirror(createMirror);
        }
        return result;
    }

    protected TypeResource doCreateResource(URI uri) {
        TypeResource result = new TypeResource(uri);
        result.setIndexedJvmTypeAccess(this.indexedJvmTypeAccess);
        return result;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public IMirror createMirror(URI resourceURI) {
        if (resourceURI.hasFragment()) {
            throw new IllegalArgumentException("Cannot create mirror for uri '" + resourceURI.toString() + "'");
        }
        String name = resourceURI.path();
        if ("/Primitives".equals(name)) {
            return new PrimitiveMirror(this.primitiveTypeFactory);
        }
        if (!name.startsWith("/Objects/")) {
            throw new IllegalArgumentException("Invalid resource uri '" + resourceURI.toString() + "'");
        }
        name = name.substring("/Objects/".length());
        return this.createMirrorForFQN(name);
    }

    protected abstract IMirror createMirrorForFQN(String var1);

    protected IndexedJvmTypeAccess getIndexedJvmTypeAccess() {
        return this.indexedJvmTypeAccess;
    }
}

