/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.LoadingResourceAccess;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorResourceAccess
implements IReferenceFinder.ILocalResourceAccess {
    private static final Logger LOG = Logger.getLogger(EditorResourceAccess.class);
    @Inject(optional=true)
    private IWorkbench workbench;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private LoadingResourceAccess delegate;

    @Override
    public <R> R readOnly(URI targetURI, final IUnitOfWork<R, ResourceSet> work) {
        Object result = null;
        IXtextDocument document = this.getOpenDocument(targetURI.trimFragment());
        if (document != null) {
            result = document.readOnly(new IUnitOfWork<R, XtextResource>(){

                public R exec(XtextResource state) throws Exception {
                    ResourceSet localContext = state.getResourceSet();
                    if (localContext != null) {
                        return work.exec((Object)localContext);
                    }
                    return null;
                }
            });
        }
        return (R)(result != null ? result : (Object)this.delegate.readOnly(targetURI, work));
    }

    protected IXtextDocument getOpenDocument(URI targetURI) {
        if (this.workbench == null) {
            return null;
        }
        Iterable<Pair<IStorage, IProject>> storagesToProject = this.storage2UriMapper.getStorages(targetURI.trimFragment());
        final Iterable storages = Iterables.transform(storagesToProject, (Function)new Function<Pair<IStorage, IProject>, IStorage>(){

            public IStorage apply(Pair<IStorage, IProject> from) {
                return (IStorage)from.getFirst();
            }
        });
        if (!Iterables.isEmpty((Iterable)storages)) {
            return (IXtextDocument)new DisplayRunnableWithResult<IXtextDocument>(){

                @Override
                protected IXtextDocument run() throws Exception {
                    IWorkbenchWindow activeWorkbenchWindow = EditorResourceAccess.this.workbench.getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return null;
                    }
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    if (activePage == null) {
                        return null;
                    }
                    IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference editorReference = iEditorReferenceArray[n2];
                        try {
                            IEditorPart editor;
                            IEditorInput editorInput = editorReference.getEditorInput();
                            if (editorInput instanceof IStorageEditorInput && Iterables.contains((Iterable)storages, (Object)((IStorageEditorInput)editorInput).getStorage()) && (editor = editorReference.getEditor(true)) instanceof XtextEditor) {
                                XtextEditor xtextEditor = (XtextEditor)editor;
                                return xtextEditor.getDocument();
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error accessing document", (Throwable)e);
                        }
                        ++n2;
                    }
                    return null;
                }
            }.syncExec();
        }
        return null;
    }
}

