/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.transformer.AbstractSemanticModelTransformer;
import org.eclipse.xtext.util.concurrent.IEObjectHandle;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentOutlineNode
implements IContentOutlineNode {
    private static final IContentOutlineNode[] EMPTY_ARRAY = new IContentOutlineNode[0];
    private StyledString styledString;
    private Image image;
    private IRegion region;
    private List<ContentOutlineNode> children;
    private IContentOutlineNode[] childrenAsArray;
    private ContentOutlineNode parent;
    private EClass eClass;
    private IEObjectHandle<EObject> handle;
    private List<IEObjectHandle<EObject>> handlesForChildren;
    private AbstractSemanticModelTransformer transformer;

    public ContentOutlineNode() {
    }

    public ContentOutlineNode(String text) {
        this.styledString = new StyledString(text);
    }

    public ContentOutlineNode(StyledString styledString) {
        this.styledString = styledString;
    }

    public ContentOutlineNode(StyledString styledString, Image image, IRegion region, IEObjectHandle<EObject> eObjectHandle, EClass eClass) {
        this.styledString = styledString;
        this.image = image;
        this.region = region;
        this.handle = eObjectHandle;
        this.eClass = eClass;
    }

    public void setStyledString(StyledString styledString) {
        this.styledString = styledString;
    }

    @Override
    public StyledString getStyledString() {
        return this.styledString;
    }

    @Override
    public String getLabel() {
        return this.styledString != null ? this.styledString.getString() : "";
    }

    public void setLabel(String label) {
        this.styledString = new StyledString(label);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public void addChildren(ContentOutlineNode contentOutlineNode) {
        contentOutlineNode.parent = this;
        this.getChildren().add(contentOutlineNode);
    }

    public List<ContentOutlineNode> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ContentOutlineNode>(2);
        }
        if (this.handlesForChildren != null) {
            this.computeChildren();
        }
        return this.children;
    }

    public void addHandleForChildren(IEObjectHandle<EObject> handle) {
        if (this.handlesForChildren == null) {
            this.handlesForChildren = Lists.newArrayListWithExpectedSize((int)1);
        }
        this.handlesForChildren.add(handle);
    }

    protected void computeChildren() {
        if (this.getTransformer() == null || this.handlesForChildren == null) {
            return;
        }
        List<IEObjectHandle<EObject>> handlesForChildren = this.handlesForChildren;
        this.handlesForChildren = null;
        for (IEObjectHandle<EObject> handleForChildren : handlesForChildren) {
            this.processHandleForChildren(handleForChildren);
        }
    }

    protected void processHandleForChildren(IEObjectHandle<EObject> handleForChildren) {
        handleForChildren.readOnly((IUnitOfWork)new IUnitOfWork.Void<EObject>(){

            public void process(EObject state) throws Exception {
                ContentOutlineNode.this.getTransformer().transformSemanticChildNodes(state, ContentOutlineNode.this);
            }
        });
    }

    @Override
    public IContentOutlineNode[] getChildrenAsArray() {
        if (this.childrenAsArray == null) {
            List<ContentOutlineNode> childList = this.getChildren();
            this.childrenAsArray = childList.isEmpty() ? EMPTY_ARRAY : this.getChildren().toArray(new IContentOutlineNode[childList.size()]);
        }
        return this.childrenAsArray;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildrenAsArray().length != 0;
    }

    @Override
    public ContentOutlineNode getParent() {
        return this.parent;
    }

    @Override
    public IRegion getRegion() {
        return this.region;
    }

    @Override
    public EClass getClazz() {
        return this.eClass;
    }

    @Deprecated
    public URI getUri() {
        return this.getURI();
    }

    public IEObjectHandle<EObject> getEObjectHandle() {
        return this.handle;
    }

    public <T> T modify(IUnitOfWork<T, EObject> work) {
        if (this.handle != null) {
            return (T)this.handle.modify(work);
        }
        return null;
    }

    public <T> T readOnly(IUnitOfWork<T, EObject> work) {
        if (this.handle != null) {
            return (T)this.handle.readOnly(work);
        }
        return null;
    }

    public URI getURI() {
        if (this.handle != null) {
            return this.handle.getURI();
        }
        return null;
    }

    @Override
    public int getSelectionOffset() {
        return this.region == null ? 0 : this.region.getOffset();
    }

    @Override
    public int getSelectionLength() {
        return this.region == null ? 0 : this.region.getLength();
    }

    public void setStyler(StyledString.Styler styler) {
        Assert.isNotNull((Object)styler, (String)"parameter 'styler' must not be null");
        StyledString styledString = this.getStyledString();
        if (styledString != null) {
            styledString.setStyle(0, styledString.getString().length(), styler);
        }
    }

    public Object getAdapter(Class expected) {
        Object adapter = Platform.getAdapterManager().getAdapter((Object)this, expected);
        return adapter;
    }

    public void setTransformer(AbstractSemanticModelTransformer transformer) {
        this.transformer = transformer;
    }

    public AbstractSemanticModelTransformer getTransformer() {
        if (this.transformer != null) {
            return this.transformer;
        }
        if (this.getParent() != null) {
            return this.getParent().getTransformer();
        }
        return null;
    }
}

