/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public class MultiLineTerminalsEditStrategy
extends AbstractEditStrategy {
    private static final Logger log = Logger.getLogger(MultiLineTerminalsEditStrategy.class);
    private String leftTerminal;
    private String rightTerminal;
    private String indentationString;
    @Inject
    private IIndentationInformation indentationInformation;
    private boolean explicitIndentation;
    private String significantRightTerminalPart;
    private String significantInsertableIndentationString;
    private String significantLookupIndentationString;

    public MultiLineTerminalsEditStrategy configure(String leftTerminal, String indentationString, String rightTerminal) {
        String insignificantPrefix = this.getInsignificantPart(indentationString, rightTerminal);
        return this.configure(leftTerminal, indentationString, rightTerminal, insignificantPrefix);
    }

    public MultiLineTerminalsEditStrategy configure(String leftTerminal, String indentationString, String rightTerminal, String insignificantPrefix) {
        this.leftTerminal = leftTerminal;
        this.rightTerminal = rightTerminal;
        this.significantRightTerminalPart = rightTerminal.substring(insignificantPrefix.length());
        this.indentationString = indentationString == null ? this.indentationInformation.getIndentString() : indentationString;
        boolean bl = this.explicitIndentation = indentationString != null;
        if (this.explicitIndentation) {
            this.significantInsertableIndentationString = this.indentationString.substring(insignificantPrefix.length());
            this.significantLookupIndentationString = this.indentationString.trim();
        }
        return this;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            if (command.length != 0) {
                return;
            }
            String originalText = command.text;
            String[] lineDelimiters = document.getLegalLineDelimiters();
            int delimiterIndex = TextUtilities.startsWith((String[])lineDelimiters, (String)originalText);
            if (delimiterIndex != -1) {
                int indentationStringIndex;
                IRegion currentLineRegion = document.getLineInformationOfOffset(command.offset);
                String currentLine = document.get(currentLineRegion.getOffset(), command.offset - currentLineRegion.getOffset());
                int lastLeftTerminal = currentLine.lastIndexOf(this.leftTerminal);
                if (lastLeftTerminal != -1) {
                    int lastRightTerminal = currentLine.lastIndexOf(this.significantRightTerminalPart);
                    if (lastRightTerminal == -1 || lastLeftTerminal > lastRightTerminal + this.leftTerminal.length()) {
                        StringBuilder commandString = new StringBuilder(lastLeftTerminal + this.indentationString.length() + command.text.length());
                        commandString.append(command.text);
                        int firstNonWsCharacter = this.findFirstNonWsCharacter(currentLine, lastLeftTerminal);
                        int numberOfSpaces = lastLeftTerminal - firstNonWsCharacter;
                        this.appendSpaces(commandString, numberOfSpaces);
                        commandString.append(this.indentationString);
                        command.text = commandString.toString();
                        command.caretOffset = command.offset + command.text.length();
                        command.shiftsCaret = false;
                        String documentContent = this.getDocumentContent(document, command);
                        int opening = this.count(this.leftTerminal, documentContent);
                        int closing = this.count(this.significantRightTerminalPart, documentContent);
                        if (opening > closing) {
                            commandString.append(originalText);
                            this.appendSpaces(commandString, numberOfSpaces);
                            commandString.append(this.rightTerminal);
                            command.text = commandString.toString();
                        } else if (currentLine.length() < currentLineRegion.getLength()) {
                            String trailingCurrentLine = document.get(currentLineRegion.getOffset(), currentLineRegion.getLength());
                            int trailingRightTerminalIndex = (trailingCurrentLine = trailingCurrentLine.substring(currentLine.length())).indexOf(this.significantRightTerminalPart);
                            if (trailingRightTerminalIndex != -1) {
                                if (this.hasNonWsBefore(trailingCurrentLine, trailingRightTerminalIndex)) {
                                    return;
                                }
                                commandString.append(originalText);
                                this.appendSpaces(commandString, numberOfSpaces);
                                commandString.append(this.rightTerminal);
                                command.text = commandString.toString();
                                command.length += trailingRightTerminalIndex + this.significantRightTerminalPart.length();
                            }
                        }
                    }
                } else if (this.explicitIndentation && this.shouldAppendIndentationString(document, command, currentLine, indentationStringIndex = currentLine.indexOf(this.significantLookupIndentationString))) {
                    StringBuilder commandString = new StringBuilder(indentationStringIndex + this.significantInsertableIndentationString.length() + command.text.length());
                    commandString.append(command.text);
                    commandString.append(this.significantInsertableIndentationString);
                    command.text = commandString.toString();
                }
            }
        }
        catch (BadLocationException ex) {
            log.error((Object)"Exception in AutoEditStrategy", (Throwable)ex);
        }
    }

    protected boolean shouldAppendIndentationString(IDocument document, DocumentCommand command, String currentLine, int indentationStringIndex) {
        if (indentationStringIndex == -1) {
            return false;
        }
        String prefixInDocument = this.getDocumentContent(document, command).substring(0, command.offset);
        int previousLeftTerminalInDocument = prefixInDocument.lastIndexOf(this.leftTerminal);
        if (previousLeftTerminalInDocument == -1) {
            return false;
        }
        int previousRightTerminalInDocument = prefixInDocument.lastIndexOf(this.significantRightTerminalPart);
        if (previousRightTerminalInDocument != -1 && previousLeftTerminalInDocument < previousRightTerminalInDocument + this.leftTerminal.length()) {
            return false;
        }
        return !this.hasNonWsBefore(currentLine, indentationStringIndex);
    }

    protected boolean hasNonWsBefore(String line, int index) {
        int idx = 0;
        while (idx < index) {
            if (!Character.isWhitespace(line.charAt(idx))) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    protected void appendSpaces(StringBuilder commandString, int count) {
        if (this.explicitIndentation) {
            int i = 0;
            while (i < count) {
                commandString.append(' ');
                ++i;
            }
        }
    }

    protected int findFirstNonWsCharacter(String currentLine, int maxIndex) {
        int i = 0;
        while (i < maxIndex) {
            if (!Character.isWhitespace(currentLine.charAt(i))) break;
            ++i;
        }
        return i;
    }

    protected String getInsignificantPart(String first, String second) {
        if (first == null || second == null) {
            return "";
        }
        int minLen = Math.min(first.length(), second.length());
        int i = 0;
        while (i < minLen) {
            if (!Character.isWhitespace(first.charAt(i)) || first.charAt(i) != second.charAt(i)) {
                return first.substring(0, i);
            }
            ++i;
        }
        return "";
    }

    @Deprecated
    protected String getNewLine() {
        return "\n";
    }
}

